/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - help.c - source file for display help

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "scan.h"

void logwrite(gchar *str, gint fnt, gint fclr, gint bclr)
{
GdkFont *font;
GdkColor color,bcolor;
GdkColormap *cmap;
gboolean nclr[2];

switch (fnt){/* load font */
 case 0:/* load normal font */
  font = gdk_font_load ("-adobe-times-medium-r-*-*-*-140-*-*-*-*-*-*");
  break;
 case 1:/* load bold font */
  font = gdk_font_load ("-adobe-times-bold-r-*-*-*-140-*-*-*-*-*-*");;
  break;
 case 2:/* load fixed normal font */
  font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-120-*-*-*-*-*-*");;
  break;
 case 3:/* load fixed bold font */
  font = gdk_font_load ("-misc-fixed-bold-r-*-*-*-100-*-*-*-*-*-*");;
  break;
 case 4:/* load normal font double size */
  font = gdk_font_load ("-adobe-times-medium-r-*-*-*-160-*-*-*-*-*-*");
  break;
 case 5:/* load bold font double size */
  font = gdk_font_load ("-adobe-times-bold-r-*-*-*-160-*-*-*-*-*-*");;
  break;
 case 6:/* load fixed normal font double size */
  font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-180-*-*-*-*-*-*");;
  break;
 case 7:/* load fixed bold font double size */
  font = gdk_font_load ("-misc-fixed-bold-r-*-*-*-160-*-*-*-*-*-*");;
  break;
 default:/* load theme default font */
  font = NULL;break;
}/* end switch font */
nclr[0]=FALSE;nclr[1]=FALSE;/* set variable for display colors */
cmap = gdk_colormap_get_system();/* alocate system colormap */
switch (fclr){/* load color */
 case 0:/* black color */
  color=helptext->style->black;break;
 case 1:/* white color */
  color=helptext->style->white;break;
 case 2:/* red color */
  color.red = 0x8080;color.green = 0;color.blue = 0;break;
 case 3:/* green color */
  color.red = 0;color.green = 0x8080;color.blue = 0;break;
 case 4:/* blue color */
  color.red = 0;color.green = 0;color.blue = 0xffff;break;
 case 5:/* orange color */
  color.red = 0xffff;color.green = 0x8080;color.blue = 0;break;
 case 6:/* magenta color */
  color.red = 0xffff;color.green = 0;color.blue = 0xffff;break;
 case 7:/* light red color */
  color.red = 0xffff;color.green = 0;color.blue = 0;break;
 case 8:/* light green color */
  color.red = 0;color.green = 0xffff;color.blue = 0;break;
 case 9:/* light blue color */
  color.red = 0x8080;color.green = 0x8080;color.blue = 0xffff;break;
 case 10:/* yellow color */
  color.red = 0xffff;color.green = 0xffff;color.blue = 0;break;
 case 11:/* light magenta color */
  color.red = 0xffff;color.green = 0x8080;color.blue = 0xffff;break;
 case 12:/* brown color */
  color.red = 0x8080;color.green = 0x4040;color.blue = 0;break;
 case 13:/* cyan color */
  color.red = 0;color.green = 0xffff;color.blue = 0xffff;break;
 default:/* use default theme color */
  nclr[0]=TRUE;break;
}/* end switch color */
if ( !gdk_color_alloc(cmap, &color) ) nclr[0]=TRUE;/* fail to alocate color */
switch (bclr){/* load color */
 case 0:/* black color */
  bcolor=helptext->style->black;break;
 case 1:/* white color */
  bcolor=helptext->style->white;break;
 case 2:/* red color */
  bcolor.red = 0x8080;bcolor.green = 0;bcolor.blue = 0;break;
 case 3:/* green color */
  bcolor.red = 0;bcolor.green = 0x8080;bcolor.blue = 0;break;
 case 4:/* blue color */
  bcolor.red = 0;bcolor.green = 0;bcolor.blue = 0xffff;break;
 case 5:/* orange color */
  bcolor.red = 0xffff;bcolor.green = 0x8080;bcolor.blue = 0;break;
 case 6:/* magenta color */
  bcolor.red = 0xffff;bcolor.green = 0;bcolor.blue = 0xffff;break;
 case 7:/* light red color */
  bcolor.red = 0xffff;bcolor.green = 0;bcolor.blue = 0;break;
 case 8:/* light green color */
  bcolor.red = 0;bcolor.green = 0xffff;bcolor.blue = 0;break;
 case 9:/* light blue color */
  bcolor.red = 0x8080;bcolor.green = 0x8080;bcolor.blue = 0xffff;break;
 case 10:/* yellow color */
  bcolor.red = 0xffff;bcolor.green = 0xffff;bcolor.blue = 0;break;
 case 11:/* light magenta color */
  bcolor.red = 0xffff;bcolor.green = 0x8080;bcolor.blue = 0xffff;break;
 case 12:/* brown color */
  bcolor.red = 0x8080;bcolor.green = 0x4040;bcolor.blue = 0;break;
 case 13:/* cyan color */
  bcolor.red = 0;bcolor.green = 0xffff;bcolor.blue = 0xffff;break;
 default:/* use default theme color */
  nclr[1]=TRUE;break;
}/* end switch color */
if ( !gdk_color_alloc(cmap, &bcolor) ) nclr[1]=TRUE;/* fail to alocate color */
if(nclr[0]) if(nclr[1])
  gtk_text_insert(GTK_TEXT (logtext), font, NULL, NULL, str, -1);
 else
  gtk_text_insert(GTK_TEXT (logtext), font, NULL, &bcolor, str, -1);
else if(nclr[1])
  gtk_text_insert(GTK_TEXT (logtext), font, &color, NULL, str, -1);
 else gtk_text_insert(GTK_TEXT (logtext), font, &color, &bcolor, str, -1);
}/* end logwrite */

void errwrite(gchar *str, gint fnt, gint fclr, gint bclr)
{
GdkFont *font;
GdkColor color,bcolor;
GdkColormap *cmap;
gboolean nclr[2];

/* help color marking structure: 2 characters,
 * first character:
 * 	4 bytes - activation 0xf0
 * 	4 bytes - foreground color (0-14)
 * second character:
 * 	4 bytes - font (0-4)
 * 	4 bytes - background color (0-14) */
switch (fnt){/* load font */
 case 0:/* load normal font */
  font = gdk_font_load ("-adobe-times-medium-r-*-*-*-140-*-*-*-*-*-*");
  break;
 case 1:/* load bold font */
  font = gdk_font_load ("-adobe-times-bold-r-*-*-*-140-*-*-*-*-*-*");;
  break;
 case 2:/* load fixed normal font */
  font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-120-*-*-*-*-*-*");;
  break;
 case 3:/* load fixed bold font */
  font = gdk_font_load ("-misc-fixed-bold-r-*-*-*-100-*-*-*-*-*-*");;
  break;
 case 4:/* load normal font double size */
  font = gdk_font_load ("-adobe-times-medium-r-*-*-*-160-*-*-*-*-*-*");
  break;
 case 5:/* load bold font double size */
  font = gdk_font_load ("-adobe-times-bold-r-*-*-*-160-*-*-*-*-*-*");;
  break;
 case 6:/* load fixed normal font double size */
  font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-180-*-*-*-*-*-*");;
  break;
 case 7:/* load fixed bold font double size */
  font = gdk_font_load ("-misc-fixed-bold-r-*-*-*-160-*-*-*-*-*-*");;
  break;
 default:/* load theme default font */
  font = NULL;break;
}/* end switch font */
nclr[0]=FALSE;nclr[1]=FALSE;/* set variable for display colors */
cmap = gdk_colormap_get_system();/* alocate system colormap */
switch (fclr){/* load color */
 case 0:/* black color */
  color=helptext->style->black;break;
 case 1:/* white color */
  color=helptext->style->white;break;
 case 2:/* red color */
  color.red = 0x8080;color.green = 0;color.blue = 0;break;
 case 3:/* green color */
  color.red = 0;color.green = 0x8080;color.blue = 0;break;
 case 4:/* blue color */
  color.red = 0;color.green = 0;color.blue = 0xffff;break;
 case 5:/* orange color */
  color.red = 0xffff;color.green = 0x8080;color.blue = 0;break;
 case 6:/* magenta color */
  color.red = 0xffff;color.green = 0;color.blue = 0xffff;break;
 case 7:/* light red color */
  color.red = 0xffff;color.green = 0;color.blue = 0;break;
 case 8:/* light green color */
  color.red = 0;color.green = 0xffff;color.blue = 0;break;
 case 9:/* light blue color */
  color.red = 0x8080;color.green = 0x8080;color.blue = 0xffff;break;
 case 10:/* yellow color */
  color.red = 0xffff;color.green = 0xffff;color.blue = 0;break;
 case 11:/* light magenta color */
  color.red = 0xffff;color.green = 0x8080;color.blue = 0xffff;break;
 case 12:/* brown color */
  color.red = 0x8080;color.green = 0x4040;color.blue = 0;break;
 case 13:/* cyan color */
  color.red = 0;color.green = 0xffff;color.blue = 0xffff;break;
 default:/* use default theme color */
  nclr[0]=TRUE;break;
}/* end switch color */
if ( !gdk_color_alloc(cmap, &color) ) nclr[0]=TRUE;/* fail to alocate color */
switch (bclr){/* load color */
 case 0:/* black color */
  bcolor=helptext->style->black;break;
 case 1:/* white color */
  bcolor=helptext->style->white;break;
 case 2:/* red color */
  bcolor.red = 0x8080;bcolor.green = 0;bcolor.blue = 0;break;
 case 3:/* green color */
  bcolor.red = 0;bcolor.green = 0x8080;bcolor.blue = 0;break;
 case 4:/* blue color */
  bcolor.red = 0;bcolor.green = 0;bcolor.blue = 0xffff;break;
 case 5:/* orange color */
  bcolor.red = 0xffff;bcolor.green = 0x8080;bcolor.blue = 0;break;
 case 6:/* magenta color */
  bcolor.red = 0xffff;bcolor.green = 0;bcolor.blue = 0xffff;break;
 case 7:/* light red color */
  bcolor.red = 0xffff;bcolor.green = 0;bcolor.blue = 0;break;
 case 8:/* light green color */
  bcolor.red = 0;bcolor.green = 0xffff;bcolor.blue = 0;break;
 case 9:/* light blue color */
  bcolor.red = 0x8080;bcolor.green = 0x8080;bcolor.blue = 0xffff;break;
 case 10:/* yellow color */
  bcolor.red = 0xffff;bcolor.green = 0xffff;bcolor.blue = 0;break;
 case 11:/* light magenta color */
  bcolor.red = 0xffff;bcolor.green = 0x8080;bcolor.blue = 0xffff;break;
 case 12:/* brown color */
  bcolor.red = 0x8080;bcolor.green = 0x4040;bcolor.blue = 0;break;
 case 13:/* cyan color */
  bcolor.red = 0;bcolor.green = 0xffff;bcolor.blue = 0xffff;break;
 default:/* use default theme color */
  nclr[1]=TRUE;break;
}/* end switch color */
if ( !gdk_color_alloc(cmap, &bcolor) ) nclr[1]=TRUE;/* fail to alocate color */
if(nclr[0]) if(nclr[1])
  gtk_text_insert(GTK_TEXT (helptext), font, NULL, NULL, str, -1);
 else
  gtk_text_insert(GTK_TEXT (helptext), font, NULL, &bcolor, str, -1);
else if(nclr[1])
  gtk_text_insert(GTK_TEXT (helptext), font, &color, NULL, str, -1);
 else gtk_text_insert(GTK_TEXT (helptext), font, &color, &bcolor, str, -1);
}/* end errwrite */

void helpwrite(guint loc)
{
FILE *f;
gchar c[2],test;
gint fgclr=14,bgclr=14,font=4;

f=fopen(HLPFILE,"rb");/* open help file for reading */
/* help error marking structure: 1 character:
 * 	1 bytes - activation 0x80
 * 	7 bytes - error code (0-110)
 * error marcation set at begining and end of error text */
gtk_text_freeze(GTK_TEXT (helptext));c[1]=0;test=0;/* set begining */
while(!feof(f)&&(test<2)){/* go thru file */
 c[0]=fgetc(f);/* read character */
 if( (c[0] & 128)==128){/* found marcation */
  if( (c[0] & 240)==240){/* color definition */
   fgclr=c[0] & 15;/* set foreground color */
   c[0]=fgetc(f);/* read next color character */
   bgclr=c[0] & 15;/* set background color */
   font=(c[0] & 240) / 16;/* set font */
  }else if( (c[0] & 127)==loc ) test++;/* start/stop writing text */
 }else if(test==1) errwrite(c,font,fgclr,bgclr);/* write character */
}/* end while feof */
gtk_text_thaw(GTK_TEXT (helptext));/* update help box */
fclose(f);/* close help file */
}/* end helpwrite */

void gethelp(guint what)
{
GtkWidget *cdscanhlp;

switch (what){/* display error or all help */
 case 0:/* display all help */
  cdscanhlp = create_cdscanhlp("CDScan Help");break;
 default:/* display errors */
  cdscanhlp = create_cdscanhlp("CDScan quick error help");break;
}/* end switch */
gtk_widget_show (cdscanhlp);
gtk_text_set_point(GTK_TEXT (helptext),0);/* clear help */
gtk_text_forward_delete(GTK_TEXT (helptext),
		        gtk_text_get_length(GTK_TEXT (helptext)));
if(access(HLPFILE, R_OK)!=0){/* can't read help file */
 errwrite("Can't read help file: ",2,1,0);errwrite(HLPFILE,3,1,0);
}else helpwrite(what);/* write help */
}/* end gethelp */
