/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - sfilesys.c - source file for scaning filesystem

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#include <gtk/gtk.h>
#include <dirent.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>

#include "scan.h"
#include "help.h"
#include "interface.h"
#include "callbacks.h"

guint FCount,DCount,DECnt,FECnt;/* file & dir count, error dir & file */
gshort mntpwd;/* current mount loaction */

gboolean progress_timeout(gpointer data)
{
register gfloat new_val;

new_val = gtk_progress_get_value( GTK_PROGRESS(fileprogres) );
new_val+=0.05;if (new_val > 2.0) new_val=0.0;
gtk_progress_set_value (GTK_PROGRESS (fileprogres), new_val);
if(new_val==0.0) gtk_progress_bar_set_orientation(\
	GTK_PROGRESS_BAR (totalprogres), GTK_PROGRESS_LEFT_TO_RIGHT);
if((new_val>=1.0)&&(new_val<1.1)) gtk_progress_bar_set_orientation(\
	GTK_PROGRESS_BAR (totalprogres), GTK_PROGRESS_RIGHT_TO_LEFT);
if(new_val > 1.0) new_val=2.0-new_val;
gtk_progress_set_value (GTK_PROGRESS (totalprogres), new_val*100);
return(TRUE);
}/* end progress_timeout() */

void getdirandfiles(gchar *root)
{
DIR *d;
struct dirent *dname;
struct stat sbuf;
gchar pwd[1024];

DCount++;/* count directoryes */
if((d=opendir(root))==NULL){/* fail to open directory */
 settolist(strerror(errno),Erow-3);addtolist(" ");/* write error */
 DECnt++;logwrite("Directory fail:",0,2,14);
 sprintf(res," %s\n",root);logwrite(res,0,3,14);
}else{/* all ok start reading */
 sprintf(pwd,"Current directory: %s",root);settolist(pwd,Erow-3);
 dname=readdir(d);/* read first item in directory */
 while( (dname!=NULL)&&ISRUN ){/* get names until end of directory */
  sprintf(pwd,"%s/%s",root,dname->d_name);/* get full path location */
  lstat(pwd,&sbuf);/* get pwd status */
  if(IGNORELINK && S_ISLNK(sbuf.st_mode)){/* include linked files/dir */
    /* **********> put here counter for links */
  }else{/* only real files and directories */
   if(S_ISDIR(sbuf.st_mode)){/* it's directory */
    if( (strcmp(dname->d_name,".")!=0)&&(strcmp(dname->d_name,"..")!=0) )
     getdirandfiles(pwd);/* go in directory */
   }else{/* other files */
    sprintf(pwd,"(%-6ld bytes) %s",sbuf.st_size,dname->d_name);
    settolist(pwd,Erow-2);FCount++;/* file count */
    scantime=time(NULL);
    totsize+=sbuf.st_size;/* count total size */
   }/* end else if DIR */
  }/* end else if is link */
  sprintf(res,"Total %-3d directories, %-4d files, %-6ld bytes",DCount,\
	FCount,totsize);settolist(res,Erow-1);/* write status */
  g_refresh();/* update events */
  if(ISRUN) dname=readdir(d);/* read first item in directory */
 }/* end while */
closedir(d);/* close directory */
}/* end else if open */
}/* end getdirandfiles() */

gboolean doscan(gpointer dummy)
{
if(ISRUN && ISSCANING){
 if(scantime+DTIME<=time(NULL))
  cdrom_reset(TRUE);/* reset cdrom and continue */
}else return(FALSE);
return(TRUE);
}/* end doscan() */

void ReadFile(gchar *Fname,gulong Fsize)
{
FILE *f;
gchar buf[10240];
register gulong rsize=0;
register gint nr=1;
register gfloat perc;

if((f=fopen(Fname,"rb"))==NULL){/* file not opened write error */
 settolist(strerror(errno),Erow-3);addtolist(" ");/* write error */
 FECnt++;logwrite("File open fail: ",0,2,14);
 strcpy(res,Fname);g_strreverse(res);res[strlen(Fname)-mntpwd]=0;
 g_strreverse(res);logwrite(g_strconcat(res,"\n",NULL),0,3,14);
}else{/* file opened do read */
 while((nr>0) && ISRUN){/* read file */
  nr=fread(buf,1,sizeof(buf),f);/* read in buffer */
  if((nr<=0)&&!feof(f)){/* ops error during read */
   settolist(strerror(errno),Erow-3);addtolist(" ");/* write error */
   rsize=0;/* reset for exit in error */
  }/* end if nr<=0 */
  scantime=time(NULL);
  rsize+=nr;/* update read status */
  perc=div((rsize/1.0)/(Fsize/1.0)*100.0,1).quot;
  if(gtk_progress_get_value(GTK_PROGRESS(fileprogres))!=perc){
   if(perc<=100.0) gtk_progress_set_value (GTK_PROGRESS (fileprogres),perc);
   sprintf(res,"Scaned %-6ld of %6ld bytes",cursize+rsize,totsize);
   settolist(res,Erow-1);perc=((cursize+rsize)/1.0)/(totsize/1.0)*100.0;
   if(gtk_progress_get_value(GTK_PROGRESS(totalprogres))!=perc){
    if(perc<=100.0) gtk_progress_set_value (GTK_PROGRESS (totalprogres),perc);
   }/* end if last percent */
   g_refresh();
  }/* end if last percent */
 }/* end while */
 fclose(f);
 if((rsize!=Fsize)&& ISRUN){/* not complete file, write error */
  FECnt++;logwrite("File read fail: ",0,2,14);
  strcpy(res,Fname);g_strreverse(res);res[strlen(Fname)-mntpwd]=0;
  g_strreverse(res);logwrite(g_strconcat(res,"\n",NULL),0,3,14);
 }/* end if rsize */
}/* end else if fopen */
cursize+=Fsize;/* count current size */
}/* end ReadFile() */

void scanfilesonly(gchar *root)
{
DIR *d;
struct dirent *dname;
struct stat sbuf;
gchar pwd[1024];

if((d=opendir(root))==NULL){/* fail to open directory */
 settolist(strerror(errno),Erow-3);addtolist(" ");/* write error */
 sprintf(pwd,"Skipping directory %s\n",root);logwrite(pwd,0,4,14);
}else{/* all ok start reading */
 sprintf(pwd,"Current directory: %s",root);settolist(pwd,Erow-3);
 dname=readdir(d);/* read first item in directory */
 while( (dname!=NULL)&&ISRUN ){/* get names until end of directory */
  sprintf(pwd,"%s/%s",root,dname->d_name);/* get full path location */
  lstat(pwd,&sbuf);/* get pwd status */
  if(IGNORELINK && S_ISLNK(sbuf.st_mode)){/* include linked files/dir */
    /* **********> put here counter for links */
  }else{/* only real files and directories */
   if(S_ISDIR(sbuf.st_mode)){/* it's directory */
    if( (strcmp(dname->d_name,".")!=0)&&(strcmp(dname->d_name,"..")!=0) )
     scanfilesonly(pwd);/* go in directory */
   }else{/* other files */
    sprintf(pwd,"Testing %s (%-6ld bytes)...",dname->d_name,sbuf.st_size);
    settolist(pwd,Erow-2);/* file count */
    ReadFile(g_strconcat(root,"/",dname->d_name,NULL),sbuf.st_size);
    scantime=time(NULL);g_refresh();/* update time and do refresh */
   }/* end else if DIR */
  }/* end else if is link */
  g_refresh();/* update events */
  if(ISRUN) dname=readdir(d);/* read first item in directory */
 }/* end while */
closedir(d);/* close directory */
}/* end else if open */
}/* end scanfiles() */

gboolean dofullscan(gpointer dummy)
{
if(ISRUN && ISSCANING){
 if(scantime+DTIME<=time(NULL))
   cdrom_reset(TRUE);/* reset cdrom and continue */
}else return(FALSE);
return(TRUE);
}/* end doscan() */

void scan_filesystem(void)
{
guint timerid;
gint stime;
gchar pwd[1024];

addtolist("Seting up for scaning ...");
if(!is_mounted()){/* check if device is mounted */
 if(MNTLOC[0]!=0){/* mount point exists, try to mount */
  if(mount(CDROM, MNTLOC, "iso9660", MS_MGC_VAL | MS_RDONLY, NULL)!=0){
   addtolist("E15: Fail to mount device !");/* not mounted */
   addtolist(strerror(errno));/* write error */
  }/* end if mount */
 }/* end if su */
}/* end is_mounted */
if(!is_mounted())/* check if device is mounted */
 addtolist("E07: Cdrom device isn't mounted, can't perform scan !");
else{/* all ok continue */
 where_mounted(pwd);mntpwd=strlen(pwd);/* get mount location and str size */ 
 sprintf(res,"Mount point at: %s",pwd);addtolist(res);/* write status */
 cursize=0;totsize=0;FCount=0;DCount=0;DECnt=0;FECnt=0;/* reset vriable */
 addtolist(" ");addtolist(" ");addtolist(" ");/*entry for dir,file,total size*/
 gtk_progress_set_activity_mode(GTK_PROGRESS (fileprogres), TRUE);
 timerid=gtk_timeout_add (50, progress_timeout, NULL);
 sprintf(res,"Scaning filesystem integrity in %s mounted on %s.\n",CDROM,\
	pwd);logwrite(res,1,14,14);
 sprintf(res,"Aborting scan if cdrom drive not respond after %d seconds.\n",\
	DTIME);logwrite(res,1,4,14);
 sprintf(res,"Starting with delay of %d seconds. (for cdrom upspining time)\n"\
	,5+DTIME);logwrite(res,0,14,14);
 scantime=time(NULL)+5;ISSCANING=TRUE;/* set time for upsining cdrom */
 stime=gtk_timeout_add (100, doscan, NULL);
 getdirandfiles(pwd);ISSCANING=FALSE;/* do scan */
 gtk_timeout_remove (stime);g_refresh();/* clean test */
 sprintf(res,"Total found %d directories and %d files.\n",DCount,FCount);
 logwrite(res,1,3,14);sprintf(res,"Total size of all files are %ld bytes\
 (~%ld.%ld Mbytes)\n",totsize,ldiv(totsize,1048576).quot,\
	ldiv(ldiv(totsize,1048576).rem,1000).quot);logwrite(res,0,3,14);
 if(ISRUN){/* write last status */
  sprintf(res,"Scaning directory structure complete, %d errors found.\n",\
	DECnt);logwrite(res,1,14,14);/* write directory status */
  addtolist("Scaning of directory structure complete.");
 }else{ /* cancel executing scan */
  sprintf(res,"Scaning directory structure interupted, %d errors found.\n",\
	DECnt);logwrite(res,1,2,14);/* write directory status */
  addtolist("Scaning interupted while scaning directory structure.");
 }/* end else if not run */
 gtk_timeout_remove (timerid);/* remove animation of progress bar */
 gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR (totalprogres),
	GTK_PROGRESS_LEFT_TO_RIGHT);/* reset to normal progress */
 gtk_progress_set_activity_mode(GTK_PROGRESS (fileprogres), FALSE);
 if(ISRUN){/* ok continue scaning */
  sprintf(res,"Starting scan in %s on %d directories and %d files.\n",pwd,\
	DCount,FCount);logwrite(res,1,4,14);
  addtolist(" ");addtolist(" ");addtolist(" ");/*entry for dir,file and size */
  scantime=time(NULL);ISSCANING=TRUE;/* setup time */
  stime=gtk_timeout_add (100, dofullscan, NULL);/* set time check */
  scanfilesonly(pwd);ISSCANING=FALSE;/* do scan */
  gtk_timeout_remove (stime);g_refresh();/* remove time check */
  if(ISRUN){/* write last status */
   sprintf(res,"Scaning files complete, %d errors found.\n",FECnt);
   logwrite(res,1,14,14);/* write file status */
   addtolist("Scaning of file structure complete.");
   logwrite("Summary information:\n",1,4,14);
   if(DECnt>0) sprintf(res,"Total scaned %d directories and there are %d\
 errors.\n",DCount,DECnt);
   else sprintf(res,"Total scaned %d directories with no errors.\n",DCount);
   logwrite(res,0,3,14);/* write directory status */
   if(FECnt>0) sprintf(res,"Total scaned %d files and there are %d errors.\n",\
	FCount,FECnt);
   else sprintf(res,"Total scaned %d files with no errors.\n",FCount);
   logwrite(res,0,3,14);/* write file status */
  }else{ /* cancel executing test */
   sprintf(res,"Scaning files interupted, %d errors found.\n",FECnt);
   logwrite(res,1,2,14);/* write directory status */
   addtolist("Scaning interupted while scaning files.");
  }/* end else if not run */
  sprintf(res,"Total scaned %ld of %ld bytes (%ld.%ld of %ld.%ld Mbytes)\n",\
	cursize,totsize,ldiv(cursize,1048576).quot,\
	ldiv(ldiv(cursize,1048576).rem,1000).quot,ldiv(totsize,1048576).quot,\
	ldiv(ldiv(totsize,1048576).rem,1000).quot);
  logwrite(res,0,3,14);/* write bytes status */
 }else addtolist("Scaning aborted !");/* scaning aborted */
 gtk_progress_bar_update (GTK_PROGRESS_BAR (fileprogres), 0.0);
 gtk_progress_bar_update (GTK_PROGRESS_BAR (totalprogres), 0.0);
 if(MNTLOC[0]!=0) if(umount(CDROM)!=0){/* something wrong */
  addtolist("E08: Fail to umount device !");
  addtolist(strerror(errno));}/* write error */
}/* end else if is mounted */
ISRUN=FALSE;scan_button();/* return to scan mode */
}/* end scan_filesystem() */
