/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - buttons.c - source file for creating buttons with picture

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#include <gtk/gtk.h>

#include "interface.h"

#include "../pixmaps/dynamite.xpm"
#include "../pixmaps/eject.xpm"
#include "../pixmaps/floppy.xpm"
#include "../pixmaps/help.xpm"
#include "../pixmaps/ineject.xpm"
#include "../pixmaps/inject.xpm"
#include "../pixmaps/scan.xpm"
/*#include "../pixmaps/stop.xpm"*/

GtkWidget *xpm_label_box (GtkWidget *parent, int picture, gchar *label_text)
{
    GtkWidget *box1;
    GtkWidget *label=NULL;
    GtkWidget *pixmapwid;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;
    gchar **data;

    /* create box for xpm and label */
    box1 = gtk_hbox_new (FALSE, 0);
    gtk_container_border_width (GTK_CONTAINER (box1), 0);

    /* get style of button.. I assume it's to get the background color. */
    style = gtk_widget_get_style(parent);

    /* now on to the xpm stuff.. load xpm */
    switch (picture){
	case 0:data=dynamite_xpm;break;/* for exit button */
	case 1:data=help_xpm;break;/* for help button */
	case 2:data=scan_xpm;break;/* for scan button */
	case 3:data=floppy_xpm;break;/* for save log button */
	case 4:data=eject_xpm;break;/* for eject button */
	case 5:data=inject_xpm;break;/* for inject button */
	case 6:data=ineject_xpm;break;/* for ineject button */
/*	case 7:data=stop_xpm;break;// for stop button */
	default:data=NULL;break;/* no such button */
     }
		
    pixmap = gdk_pixmap_create_from_xpm_d (parent->window, &mask,
		    &style->bg[GTK_STATE_NORMAL],(gchar **)data );

    pixmapwid = gtk_pixmap_new (pixmap, mask);

    /* create label for button */
    if(picture==2)/* for scan button set label active */
     scanlabel = gtk_label_new (label_text);
    else/* create other labels */
     label = gtk_label_new (label_text);

    /* pack the pixmap and label into the box */
    gtk_box_pack_start (GTK_BOX (box1),
                        pixmapwid, TRUE, FALSE, 3);

    if(picture==2)/* for scan button set new packing */
     gtk_box_pack_start (GTK_BOX (box1), scanlabel, TRUE, FALSE, 3);
    else/* pack other labels */
     gtk_box_pack_start (GTK_BOX (box1), label, TRUE, FALSE, 3);

    gtk_widget_show(pixmapwid);
    if(picture==2)/* for scan button show label */
     gtk_widget_show(scanlabel);
    else/* show for other labels */
     gtk_widget_show(label);

    return (box1);
}/* end xpm_label_box() */
