/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - callbacks.c - source file for shecking callback calls

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/mount.h>
#include <linux/cdrom.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "help.h"
#include "scan.h"


void scan_clicked (GtkButton *button, gpointer user_data)
{
if(ISRUN){ISRUN=FALSE;scan_button();/* stop is clicked */
}else{/* start scaning */
 stop_button();ISRUN=TRUE;
/* gtk_clist_clear(GTK_CLIST (errlist));Erow=0;Srow=-1;// clear err log */
 gtk_text_set_point(GTK_TEXT (logtext),0);/* clear log */
 gtk_text_forward_delete(GTK_TEXT (logtext),
	gtk_text_get_length(GTK_TEXT (logtext)));
 switch (STYPE){/* check scan type */
  case 0:/* image of device */
        sync();close(cdd);if(CDROM[0]!=0) open_dev(CDROM);/* try open device */
        if(cdd!=-1) scan_image();/* device opened, start scaning */ 
        else{ addtolist("Can't perform scaning, device not opened !");
	 ISRUN=FALSE;scan_button();}/* end else if not opened */
	break;
  case 1:/* filesystem and files integrity */
	close(cdd); if(CDROM[0]!=0) open_dev(CDROM);/* try to open device */
	if(cdd!=-1) scan_filesystem();/* device opened, start scaning */
	else{ addtolist("Can't perform scaning, device not opened !");
	 ISRUN=FALSE;scan_button();}/* end else if not opened */
	break;
  case 2:/* audio cd media */
	addtolist("This type of scaning isn't supported yet !");
	scan_button();ISRUN=FALSE;
	break;
  case 3:/* empty cd media (recorders only) */
	addtolist("This type of scaning isn't supported yet !");
	scan_button();ISRUN=FALSE;
	break;
  default: sprintf(res,"Invalid request: %d ! This entry isn't supported for scaning.",STYPE);
	addtolist(res);res[0]=0;scan_button();ISRUN=FALSE;break;
 }/* end switch */
}/* end else if ISRUN */
}/* end scan_clicked() */

void savelogbutton_clicked (GtkButton *button, gpointer user_data)
{
GtkWidget *savelog;

if(ISRUN){/* program runing */
 settolist("Program runing, can't save log, stop program first !",Erow-1);
 addtolist(" ");/* put empty string to set row for program writing */
}else if(gtk_text_get_length(GTK_TEXT (logtext))==0)/* nothing to save */
 addtolist("There's no data to be saved in log file.");
else{/* there is data, save it */
 strcpy(res,g_strconcat(g_get_home_dir(),"/cdscan.log",NULL));/* default */
 savelog = create_savelog("Select where to save log",res,1);
 gtk_widget_show (savelog);
}/* end else get lenght */
}/* end savelogbutton_clicked() */

void adddevice_clicked (GtkButton *button, gpointer user_data)
{
GtkWidget *savelog;

if(ISRUN){/* program runing */
 settolist("Program runing, can't change device, stop program first !",Erow-1);
 addtolist(" ");/* put empty string to set row for program writing */
}else{/* program not runing do selection of device */
if(CDROM[0]!=0)/* set selected device for default */
 savelog = create_savelog("Select CDROM device",CDROM,0);
else/* set default device */
 savelog = create_savelog("Select CDROM device","/dev/cdrom",0);
gtk_widget_show (savelog);
}/* end else if ISRUN */
}/* end adddevice_clicked() */

void helpbutton_clicked (GtkButton *button, gpointer user_data)
{ gethelp(0); }

void ejectbutton_clicked (GtkButton *button, gpointer user_data)
{
if(ISRUN){/* program runing */
 settolist("Program runing, can't eject, stop program first !",Erow-1);
 addtolist(" ");/* put empty string to set row for program writing */
}else if(cdd==-1){/* device not opened */
 if(CDROM[0]!=0) open_dev(CDROM);/* ok device exists */
 if(cdd!=-1){/* all ok eject media */ 
  if(is_mounted()){/* check if device is mounted */
   if(MNTLOC[0]!=0){/* mount point exists, try to umount */
    if(umount(CDROM)!=0){/* something wrong */
     addtolist("E08: Fail to umount device !");
     addtolist(strerror(errno));/* write error */
    }else if(ioctl(cdd, CDROMEJECT)!=0){/* o.k. device umounted eject */
     addtolist("E09: Fail to eject from device !");
     addtolist(strerror(errno));/* write error */
    }/* end if ioctl fail */
   }else/* device is mounted but program can't umount */
    addtolist("E10: Can't eject, device mounted !");
  }else if(ioctl(cdd, CDROMEJECT)!=0){/* device isn't mounted eject */
   addtolist("E09: Fail to eject from device !");
   addtolist(strerror(errno));/* write error */
  }/* end else if is mounted */
 }/* end if cdd */
}else{/* device open, eject media */
 if(is_mounted()){/* check if device is mounted */
  if(MNTLOC[0]!=0){/* mount point exists, try to umount */
   if(umount(CDROM)!=0){/* something wrong */
    addtolist("E08: Fail to umount device !");
    addtolist(strerror(errno));/* write error */
   }else if(ioctl(cdd, CDROMEJECT)!=0){/* o.k. device umounted eject */
    addtolist("E09: Fail to eject from device !");
    addtolist(strerror(errno));/* write error */
   }/* end if ioctl fail */
  }else/* device is mounted but program can't umount */
   addtolist("E10: Can't eject, device mounted !");
 }else if(ioctl(cdd, CDROMEJECT)!=0){/* device isn't mounted eject */
  addtolist("E09: Fail to eject from device !");
  addtolist(strerror(errno));/* write error */
 }/* end else if is mounted */
}/* end else if cdd */
}/* end ejectbutton_clicked() */

void inject_clicked (GtkButton *button, gpointer user_data)
{
if(ISRUN){/* program runing */
 settolist("Program runing? Hmmm... And cdrom door is open on this device?",\
 Erow-1);addtolist("Manualy door opening while program runing is not good,\
 can't inject.");
 addtolist("Bdw, there are a lot easy ways to destroy your cdrom drive.");
 addtolist(" ");/* put empty string to set row for program writing */
}else if(cdd==-1){/* device not opened */
 if(CDROM[0]!=0) open_dev(CDROM);/* ok device exists */
 if(cdd!=-1){/* all ok inject media */ 
  if(is_mounted())/* check if device is mounted */
   addtolist("Device is mounted, so there must be media in drive and cd door must be closed. Why you want close closed cd door?");
  else if(ioctl(cdd, CDROMCLOSETRAY)!=0){/* inject cd media */
   addtolist("E12: Fail to inject from device !");
   addtolist(strerror(errno));/* write error */
  }/* end else if is mounted */
 }/* end if cdd */
}else{/* device open, inject media */
 if(is_mounted())/* check if device is mounted */
  addtolist("Device is mounted, so there must be media in drive and cd door must be closed. Why you want close closed cd door?");
 else if(ioctl(cdd, CDROMCLOSETRAY)!=0){/* inject cd media */
  addtolist("E12: Fail to inject from device !");
  addtolist(strerror(errno));/* write error */
 }/* end else if is mounted */
}/* end else if cdd */
}/* end inject_clicked() */

void closebutton_clicked (GtkWidget *widget, gpointer user_data)
{
if(ISRUN) ISRUN=FALSE;g_refresh();/* set to cancel program and wait one turn */
if(cdd!=-1) close(cdd);/* there is open device, close it */
if(MNTLOC[0]!=0){/* mount point exists, delete it */
 if(is_mounted()){/* check if device is mounted */
  if(umount(CDROM)!=0)/* something wrong in umount */
   g_print("\nFail to umount device !\n %s: %s\n",CDROM,strerror(errno));
 }/* end if is mounted */
 if(rmdir(MNTLOC)!=0)/* fail to remove */
  g_print("\nFail to clean mount point:\n %s: %s\n",MNTLOC,strerror(errno));
}/* end if MNTLOC */
gtk_main_quit ();
}/* end closebutton_clicked() */

void help_button_event (GtkWidget *list, GdkEventButton *event)
{
gchar *text,br[3];

if (event->type==GDK_2BUTTON_PRESS || event->type==GDK_3BUTTON_PRESS) {
 if(Srow>=0){/* ok something is selected */
  gtk_clist_get_text(GTK_CLIST(list), Srow, 0, &text);
  if( (text[0]=='E')&&(text[3]==':')&&(text[4]==' ') ){/* display err help */
   br[0]=text[1];br[1]=text[2];br[2]=0;/* get no of error */
   gethelp(atoi(br));
  }/* end if error */
 }/* end if Srow >=0 */
}/* end if event */
}

void selection_made( GtkWidget *clist, gint row, gint column,
	GdkEventButton *event, gpointer data) { Srow=row; }

void file_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
strcpy(res, gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
gtk_widget_destroy(GTK_WIDGET (w->parent->parent->parent));
getcdromlocation(res);/* test device */
res[0]=0;/* reset */
}

void file_log_sel (GtkWidget *w, GtkFileSelection *fs)
{
FILE *f;
gint i;
gfloat per,cur=0;

strcpy(res, gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
gtk_widget_destroy(GTK_WIDGET (w->parent->parent->parent));
if( (f=fopen(res,"w"))==NULL ){/* fail to open file */
 addtolist("E13: Can't write to log file !");
 addtolist(strerror(errno));/* write error */
}else{/* file open ok, write log */
 i=0;while(i<gtk_text_get_length(GTK_TEXT (logtext))){/* go thru text */
  fputc(GTK_TEXT_INDEX(GTK_TEXT (logtext),i),f);i++;/* write into log */
  per=i/gtk_text_get_length(GTK_TEXT (logtext));
  if( per!=cur )/*update changes only*/
   gtk_progress_bar_update (GTK_PROGRESS_BAR (fileprogres), per);
  cur=per;/* set curent pozition */
 }/* end while */
 fclose(f);
 gtk_progress_bar_update (GTK_PROGRESS_BAR (fileprogres), 0);
}/* end else if fopen */
res[0]=0;/* reset */
}

void scan_type (GtkWidget *item,gint where){ STYPE=where; }
