/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - config.c - source file for reading configuration file

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "interface.h"
#include "callbacks.h"
#include "scan.h"

gboolean loadconf(gchar *FNAME)
{
gchar lin[512],vars[128],vals[512];
gint i,j;
FILE *f;

if ((f=fopen(FNAME,"r"))==NULL) return(TRUE);/* can't open config file */

while(!feof(f)){/* go thru file */
 lin[0]=0;fgets(lin,512,f);/* read line */
 if ( (lin[0]!=32)&&(lin[0]!='\n')&&(lin[0]!='#')&&(lin[0]!=0) ){
  /* read only uncomment and empty lines */
  i=0;/* reset to begining of line */
  while( (lin[i]!=32)&&(lin[i]!=0)&&(lin[i]!=13)&&(lin[i]!=10) ){
   vars[i]=lin[i];i++;}/* end of while first part */
  vars[i]=0;j=0;/* close word from first part */
  while( lin[i+j]!=0 ){/* Read last part */
   j++;vals[j-1]=lin[i+j];}/* end of while second part */
  if(vals[j-2]=='\n') vals[j-2]=0;/* close word from second part */
  else vals[j-1]=0;/* close word from second part */
  if( strcmp(vars,"HELPFILE")==0 )/* check for help file */
   strcpy(HLPFILE,vals);/* found help file, update variable */
  if( strcmp(vars,"TMPDEF")==0 )/* check for default temp destination */
   strcpy(MNTLOC,vals);/* found default temp destination, update variable */
  if( strcmp(vars,"CDROMDEV")==0 )/* check for default cdrom device */
   strcpy(CDROM,vals);/* found cdrom device, update variable */
  if( strcmp(vars,"TIME_DELAY")==0 )/* check for delay time value */
   DTIME=atoi(vals);/* found delay time, update variable */
  if( strcmp(vars,"USERMOUNT")==0 )/* check for user mount option */
   USERMOUNT=TRUE;/* found user mount option, update variable */
  if( strcmp(vars,"IGNORELINK")==0 )/* check for folow link option */
   IGNORELINK=TRUE;/* found folow link option, update variable */
 }/* end if lin not comment */
}/* end while eof */
fclose(f);/* close file */
return(FALSE);/* return success */
}/* end loadconf() */
