/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - interface.c - source file for creating graphic interface

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "buttons.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "scan.h"

void scan_init_button(void)
{
GtkWidget *pixbutton;

if(scanbutton){ /* destroy existing button */
gtk_widget_hide (GTK_WIDGET (scanbutton));
gtk_widget_destroy (GTK_WIDGET (scanbutton));
}/* end if button exists */
scanbutton = gtk_button_new ();
pixbutton = xpm_label_box(mainwin, 2, "SCAN");
gtk_widget_show(pixbutton);
gtk_container_add (GTK_CONTAINER (scanbutton), pixbutton);
gtk_widget_ref (scanbutton);
gtk_object_set_data_full (GTK_OBJECT (mainwin), "scanbutton", scanbutton, (GtkDestroyNotify) gtk_widget_unref);
gtk_widget_show (scanbutton);
gtk_table_attach (GTK_TABLE (table1), scanbutton, 0, 1, 2, 3,
                 (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
gtk_container_set_border_width (GTK_CONTAINER (scanbutton), 2);

gtk_signal_connect (GTK_OBJECT (scanbutton), "clicked",
                      GTK_SIGNAL_FUNC (scan_clicked), NULL);
}/* end scan_init_button() */

void scan_button(void)
{
if(scanbutton){/* scan button is here, show it */
 gtk_label_set_text(GTK_LABEL (scanlabel), "SCAN");
 gtk_widget_show(scanlabel);
}else scan_init_button();/* no button? create it */
}/* end scan_button() */

void stop_button(void)
{
gtk_label_set_text(GTK_LABEL (scanlabel), "STOP");
gtk_widget_show(scanlabel);
}/* end stop_button() */

GtkWidget* create_mainwin (void)
{
  GtkWidget *ejectbutton;
  GtkWidget *inject;
  GtkWidget *combo_entry1;
  GtkWidget *savelogbutton;
  GtkWidget *helpbutton;
  GtkWidget *box;
  GtkWidget *scrolledwindow4;
  GtkWidget *scrolledwindow2;
  gchar *titles[]={"PROGRAM RUNTIME ERROR LOG"};
  GtkWidget *closebutton;
  GtkWidget *pixbutton;
  GtkWidget *glade_menuitem;

  mainwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (mainwin), "mainwin", mainwin);
  gtk_container_set_border_width (GTK_CONTAINER (mainwin), 2);
  gtk_window_set_title (GTK_WINDOW (mainwin), g_strconcat("CDScan Version ",\
VERSION,NULL));
  gtk_widget_realize(mainwin);

  table1 = gtk_table_new (6, 3, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (mainwin), table1);

  ejectbutton = gtk_button_new ();
  pixbutton = xpm_label_box(mainwin, 4, "Eject media");
  gtk_widget_show(pixbutton);
  gtk_container_add (GTK_CONTAINER (ejectbutton), pixbutton);
  gtk_widget_ref (ejectbutton);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "ejectbutton", ejectbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ejectbutton);
  gtk_table_attach (GTK_TABLE (table1), ejectbutton, 0, 1, 4, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (ejectbutton, 165, 42);
  gtk_container_set_border_width (GTK_CONTAINER (ejectbutton), 2);

  fileprogres = gtk_progress_bar_new ();
  gtk_widget_ref (fileprogres);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "fileprogres", fileprogres,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileprogres);
  gtk_table_attach (GTK_TABLE (table1), fileprogres, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (fileprogres, 280, 20);

  totalprogres = gtk_progress_bar_new ();
  gtk_widget_ref (totalprogres);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "totalprogres", totalprogres,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (totalprogres);
  gtk_table_attach (GTK_TABLE (table1), totalprogres, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (totalprogres, 280, 20);

  inject = gtk_button_new ();
  pixbutton = xpm_label_box(mainwin, 5, "Inject media");
  gtk_widget_show(pixbutton);
  gtk_container_add (GTK_CONTAINER (inject), pixbutton);
  gtk_widget_ref (inject);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "inject", inject,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (inject);
  gtk_table_attach (GTK_TABLE (table1), inject, 2, 3, 4, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (inject, 165, 42);
  gtk_container_set_border_width (GTK_CONTAINER (inject), 2);

  scan_button(); /* show scan button only */

  seltype = gtk_option_menu_new ();
  gtk_widget_ref (seltype);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "seltype", seltype,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (seltype);
  gtk_table_attach (GTK_TABLE (table1), seltype, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (seltype, 280, -2);
  gtk_container_set_border_width (GTK_CONTAINER (seltype), 2);

  combo_entry1 = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("image of device"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		  GTK_SIGNAL_FUNC (scan_type), GINT_TO_POINTER (0));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (combo_entry1), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("filesystem and files integrity"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		  GTK_SIGNAL_FUNC (scan_type), GINT_TO_POINTER (1));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (combo_entry1), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("audio cd media"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		  GTK_SIGNAL_FUNC (scan_type), GINT_TO_POINTER (2));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (combo_entry1), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("empty cd media (recorders only)"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		  GTK_SIGNAL_FUNC (scan_type), GINT_TO_POINTER (3));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (combo_entry1), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (seltype), combo_entry1);
  gtk_widget_show (seltype);

  savelogbutton = gtk_button_new ();
  pixbutton = xpm_label_box(mainwin, 3, "Save log");
  gtk_widget_show(pixbutton);
  gtk_container_add (GTK_CONTAINER (savelogbutton), pixbutton);
  gtk_widget_ref (savelogbutton);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "savelogbutton", savelogbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (savelogbutton);
  gtk_table_attach (GTK_TABLE (table1), savelogbutton, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (savelogbutton), 2);

  helpbutton = gtk_button_new ();
  pixbutton = xpm_label_box(mainwin, 1, "Help");
  gtk_widget_show(pixbutton);
  gtk_container_add (GTK_CONTAINER (helpbutton), pixbutton);
  gtk_widget_ref (helpbutton);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "helpbutton", helpbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (helpbutton);
  gtk_table_attach (GTK_TABLE (table1), helpbutton, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (helpbutton), 2);

  scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow4);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "scrolledwindow4", scrolledwindow4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow4);
  gtk_table_attach (GTK_TABLE (table1), scrolledwindow4, 0, 3, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_widget_set_usize (scrolledwindow4, -2, 200);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow4), 2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow4), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  logtext = gtk_text_new (NULL, NULL);
  gtk_widget_ref (logtext);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "logtext", logtext,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (logtext);
  gtk_container_add (GTK_CONTAINER (scrolledwindow4), logtext);
  gtk_widget_realize (logtext);
  gtk_text_insert (GTK_TEXT (logtext), NULL, NULL, NULL,
                   _("Log..."), 6);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow2);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), 
		  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolledwindow2);
  gtk_table_attach (GTK_TABLE (table1), scrolledwindow2, 0, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_widget_set_usize (scrolledwindow2, -2, 200);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow2), 2);

  errlist = gtk_clist_new_with_titles (1, titles);
  gtk_widget_ref (errlist);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "errlist", errlist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (errlist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), errlist);
  gtk_clist_set_column_width (GTK_CLIST (errlist), 0, 512);
  gtk_clist_set_selection_mode(GTK_CLIST (errlist), GTK_SELECTION_SINGLE);
  gtk_clist_column_title_passive(GTK_CLIST (errlist), 0);
  gtk_clist_column_titles_show (GTK_CLIST (errlist));

  devicebutton = gtk_button_new ();
  box = gtk_hbox_new (FALSE, 0);
  devicelabel = gtk_label_new ("/dev/cdrom");
  gtk_box_pack_start (GTK_BOX (box), devicelabel, TRUE, FALSE, 1);
  gtk_widget_show(devicelabel);gtk_widget_show(box);
  gtk_container_add (GTK_CONTAINER (devicebutton), box);
  gtk_widget_ref (devicebutton);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "devicebutton", devicebutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (devicebutton);
  gtk_table_attach (GTK_TABLE (table1), devicebutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_widget_set_usize (devicebutton, 280, -2);
  gtk_container_set_border_width (GTK_CONTAINER (devicebutton), 2);

  closebutton = gtk_button_new ();
  pixbutton = xpm_label_box(mainwin, 0, "Exit");
  gtk_widget_show(pixbutton);
  gtk_container_add (GTK_CONTAINER (closebutton), pixbutton);
  gtk_widget_ref (closebutton);
  gtk_object_set_data_full (GTK_OBJECT (mainwin), "closebutton", closebutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (closebutton);
  gtk_table_attach (GTK_TABLE (table1), closebutton, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (closebutton), 2);

  gtk_signal_connect (GTK_OBJECT (ejectbutton), "clicked",
                      GTK_SIGNAL_FUNC (ejectbutton_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (inject), "clicked",
                      GTK_SIGNAL_FUNC (inject_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (savelogbutton), "clicked",
                      GTK_SIGNAL_FUNC (savelogbutton_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (helpbutton), "clicked",
                      GTK_SIGNAL_FUNC (helpbutton_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (devicebutton), "clicked",
                      GTK_SIGNAL_FUNC (adddevice_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (closebutton), "clicked",
		      GTK_SIGNAL_FUNC (closebutton_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (mainwin), "destroy",
		      GTK_SIGNAL_FUNC (closebutton_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (mainwin), "delete_event",
		      GTK_SIGNAL_FUNC (closebutton_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (errlist), "button_release_event",
		      GTK_SIGNAL_FUNC(help_button_event), NULL);
  gtk_signal_connect (GTK_OBJECT (errlist), "button_press_event",
		      GTK_SIGNAL_FUNC(help_button_event), NULL);
  gtk_signal_connect (GTK_OBJECT (errlist), "select_row",
		      GTK_SIGNAL_FUNC(selection_made), NULL);

  return mainwin;
}

GtkWidget* create_savelog (gchar *title, gchar *defloc, gint what)
{
  GtkWidget *savelog;
  GtkWidget *ok_button1;
  GtkWidget *cancel_button1;

  savelog = gtk_file_selection_new (title);
  gtk_object_set_data (GTK_OBJECT (savelog), "savelog", savelog);
  gtk_container_set_border_width (GTK_CONTAINER (savelog), 2);

  ok_button1 = GTK_FILE_SELECTION (savelog)->ok_button;
  gtk_object_set_data (GTK_OBJECT (savelog), "ok_button1", ok_button1);
  gtk_widget_show (ok_button1);
  GTK_WIDGET_SET_FLAGS (ok_button1, GTK_CAN_DEFAULT);

  cancel_button1 = GTK_FILE_SELECTION (savelog)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (savelog), "cancel_button1", cancel_button1);
  gtk_widget_show (cancel_button1);
  GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (savelog), defloc);

  switch (what){/* what part to activate */
   case 0:/* device selection */
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (savelog)->ok_button), "clicked", (GtkSignalFunc) file_ok_sel, savelog );
	break;
   case 1:/* save log selection */
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (savelog)->ok_button), "clicked", (GtkSignalFunc) file_log_sel, savelog );
	break;
  }/* end switch */
  gtk_signal_connect_object (
		GTK_OBJECT (GTK_FILE_SELECTION (savelog)->cancel_button),
		"clicked", (GtkSignalFunc) gtk_widget_destroy,
		GTK_OBJECT (savelog));
  gtk_signal_connect (GTK_OBJECT (savelog), "destroy",
		(GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (savelog));
  gtk_signal_connect (GTK_OBJECT (savelog), "delete_event",
		(GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (savelog));
  return savelog;
}

GtkWidget* create_cdscanhlp (gchar *title)
{
  GtkWidget *cdscanhlp;
  GtkWidget *dialog_vbox1;
  GtkWidget *scrolledwindow3;
  GtkWidget *dialog_action_area1;
  GtkWidget *helpokbutton;

  cdscanhlp = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (cdscanhlp), "cdscanhlp", cdscanhlp);
  gtk_window_set_title (GTK_WINDOW (cdscanhlp), title);
  gtk_window_set_policy (GTK_WINDOW (cdscanhlp), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (cdscanhlp)->vbox;
  gtk_object_set_data (GTK_OBJECT (cdscanhlp), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow3);
  gtk_object_set_data_full (GTK_OBJECT (cdscanhlp), "scrolledwindow3", scrolledwindow3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow3);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), scrolledwindow3, TRUE, TRUE, 0);
  gtk_widget_set_usize (scrolledwindow3, 600, 300);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  helptext = gtk_text_new (NULL, NULL);
  gtk_widget_ref (helptext);
  gtk_object_set_data_full (GTK_OBJECT (cdscanhlp), "helptext", helptext,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (helptext);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), helptext);
  gtk_widget_realize (helptext);
  gtk_text_set_word_wrap(GTK_TEXT (helptext), TRUE);
  gtk_text_insert (GTK_TEXT (helptext), NULL, NULL, NULL,
                   _("Help..."), 7);

  dialog_action_area1 = GTK_DIALOG (cdscanhlp)->action_area;
  gtk_object_set_data (GTK_OBJECT (cdscanhlp), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 5);

  helpokbutton = gtk_button_new_with_label (_("A haaa, that's it !"));
  gtk_widget_ref (helpokbutton);
  gtk_object_set_data_full (GTK_OBJECT (cdscanhlp), "helpokbutton",
		  helpokbutton, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (helpokbutton);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), helpokbutton, FALSE, TRUE, 0);

  gtk_signal_connect_object (GTK_OBJECT (helpokbutton), "clicked",
		(GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (cdscanhlp));
  gtk_signal_connect (GTK_OBJECT (cdscanhlp), "destroy",
		(GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (cdscanhlp));
  gtk_signal_connect (GTK_OBJECT (cdscanhlp), "delete_event",
		(GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (cdscanhlp));

  return cdscanhlp;
}
