/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - load.c - source file for initialization of program

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#include <gtk/gtk.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/mount.h>
#include <linux/cdrom.h>
#include <sys/ioctl.h>

#include "interface.h"
#include "callbacks.h"
#include "scan.h"
#include "help.h"

void addtolist(gchar *str)
{ gtk_clist_append(GTK_CLIST (errlist), &str); Erow++; 
 gtk_clist_moveto (GTK_CLIST (errlist),Erow-1,0,1,1);}

void settolist(gchar *str, gint where)
{ gtk_clist_set_text(GTK_CLIST (errlist),where,0,str); }

void open_dev(gchar *devname)
{
gint i;

if(cdd!=-1) close(cdd);/* there is alredy open some device, close it */
cdd=open(devname,O_RDONLY);/* open device */
if(cdd==-1) /* uh?, fail to open device, hmmm... */
 addtolist("E06: Fail to open device !");
else{/* cdrom device opened scan if it's scsi */
 scsi_cmd.inlen=0;scsi_cmd.outlen=40;scsi_cmd.cmd[1]=0;scsi_cmd.cmd[2]=0;
 scsi_cmd.cmd[0]=0x1c;/* send inquiry */
 scsi_cmd.cmd[3]=0;scsi_cmd.cmd[4]=0;scsi_cmd.cmd[5]=0;
 if (ioctl(cdd,SCSI_IOCTL_SEND_COMMAND,(void *)&scsi_cmd)) ISSCSI=FALSE;
 else{/* device is on scsi controler */ 
  ISSCSI=TRUE;/* set to scsi device */
  for(i=0;i<24;i++) scsi_cmd.cmd[i]=scsi_cmd.cmd[i+8];scsi_cmd.cmd[24]=0;
  addtolist("Detected scsi on selected device, drive information:");
  addtolist(scsi_cmd.cmd);/* write what is found */
 }/* end else ioctl */
}/* end else if cdd */
}/* end open_dev() */

gboolean g_readlink(gchar *PwdLnk)
{
gboolean test;
gint status;
gchar a[1024],rez[1024],*s;

strcpy(a,PwdLnk);test=FALSE;/* copy link location and set to no link */
status=readlink(a, rez, 1024);
while (status != -1){/* ok read link */
 test=TRUE;rez[status]=0;/* set end of string */
 if (rez[0] == '/') strcpy(a, rez); /* it's absolute link */
 else{/* it's a relative link */
   s=strrchr(a, '/');
   if(s!=0){ s[1]=0; strcat(a, rez); }
 }/* end else relative link */
 realpath(a,rez);/* get real path */
 if(strcmp(rez,PwdLnk)==0) status=-1;/* identical? abort ... */
 else{/* continue reading link */
  strcpy(PwdLnk,rez);strcpy(a,rez);status=readlink(a, rez, 1024);
 }/* end else if identical */
}/* end while */
return(test);
}/* end g_readlink() */

void getcdromlocation(gchar *alias)
{
gchar a[1024];
guint ret;
struct stat buf;

if(alias[0]==0){/* no requested location of device */
 /* get default device from $CDROM environment variable,
  * if not set then use compiled in default */
 if (getenv("CDROM")!=NULL) strcpy(a,getenv("CDROM"));
 else strcpy(a,"/dev/cdrom");
}else strcpy(a,alias);/* end else if alias exists */

ret=0;/* set for no device found */
if(access(a,R_OK)==0){/* found device file */
 strcpy(CDROM,a);ret++;/* set to found device */
 if(g_readlink(CDROM)){/* it's link */
  strcpy(alias,a);ret++;/* set to found link of device */
 }/* end if link */
}/* end else if access */
/************ here mising test if device is cdrom *****************/
if(ret>0){/* test device */
 if(stat(CDROM,&buf)!=0) ret=4;/* can't access to device */
 else{/* all ok read type of device */
  if(!S_ISBLK(buf.st_mode)) ret=3;/* it's not block device */
 }/* end else if stat */
 if( (ret==1)||(ret==2) ) open_dev(CDROM);/* open device */
}/* end if ret>0 */
switch (ret){
 case 0:/* can't find cdrom device */
	 addtolist("E01: Not found cdrom device !");
	 setbuttontitle("Select CDROM device here");
	 CDROM[0]=0;/* set to no cdrom device */
	 break;
 case 1:/* cdrom device found */
	 setbuttontitle(CDROM);
	 break;
 case 2:/* cdrom device is link */
	 strcat(alias," is link to ");strcat(alias,CDROM);
	 addtolist(alias);
	 setbuttontitle(CDROM);
	 break; 
 case 3:/* device is not cdrom device */
	 strcat(alias," is not block device !");
	 addtolist(alias);
	 setbuttontitle("Select CDROM device here");
	 CDROM[0]=0;/* set to no cdrom device */
	 break;
 case 4:/* fail to get stat */
	 strcpy(alias,"E02: Access to ");strcat(alias,CDROM);
	 strcat(alias," fail !");addtolist(alias);
	 setbuttontitle("Select CDROM device here");
	 CDROM[0]=0;/* set to no cdrom device */
	 break;
}/* end switch */
}/* end getcdromlocation() */

void setbuttontitle (gchar *label)
{
gtk_label_set_text(GTK_LABEL (devicelabel), label);
gtk_widget_show(devicelabel);
}/* end setbuttontitle() */

void load_prog()
{
gchar alias[1024];
struct stat buf;

Erow=0;Srow=-1;cdd=-1;/* set begining of data */
gtk_clist_clear(GTK_CLIST (errlist));/* clear err log */
addtolist("Initializing program ...");
gtk_text_set_point(GTK_TEXT (logtext),0);/* clear log */
gtk_text_forward_delete(GTK_TEXT (logtext),
	gtk_text_get_length(GTK_TEXT (logtext)));
strcpy(alias,g_strconcat(g_get_home_dir(),"/.cdscan/cdscan.conf",NULL));
CDROM[0]=0;strcpy(MNTLOC,"/tmp");DTIME=0;IGNORELINK=FALSE;/* default */
strcpy(HLPFILE,"/usr/local/share/cdscan/cdscan.hlp");USERMOUNT=FALSE;
if(loadconf(alias)){/* ops can't read user config file? */
 strcpy(alias,"/usr/local/share/cdscan/cdscan.conf");
 if(loadconf(alias))/* ops can't read default config file? */
  addtolist("E05: Can't access config file, using default values.");
}/* end if loadconf */
alias[0]=0;
getcdromlocation(alias);/* check default cdrom */
if( (geteuid()!=0) && !USERMOUNT) /* not a super user */
 MNTLOC[0]=0;/* no mount location */
else{/* program have superuser bit */
 addtolist("Detecting superuser privilege, using auto-mount/umount feature.");
 strcat(MNTLOC,"/.cdscan.XXXXXX");mktemp(MNTLOC);
 if(mkdir(MNTLOC,S_IRWXU)==-1)/* try to create directory for mounting */
  addtolist(strerror(errno));/* write error */
 if(stat(MNTLOC,&buf)!=0){ /* can't access to tmp mount directory  */
  sprintf(alias,"E03: Can't access mount point %s !",MNTLOC);addtolist(alias);
  addtolist("Switching to safe scan without auto-mount/umount feature.");
  MNTLOC[0]=0;/* set to no mount point */
 }else{/* all ok read type of device */
  if(!S_ISDIR(buf.st_mode)){/* it's not directory */
   sprintf(alias,"E04: Mount point %s isn't directory !",MNTLOC);
   addtolist(alias);MNTLOC[0]=0;/* set to no mount point */
   addtolist("Switching to safe scan without auto-mount/umount feature.");
  }/* end if is directory */
 }/* end else if stat */
}/* end else if uid */
if( (DTIME<1)||(DTIME>15) ) DTIME=2;/* set correction in time delay */
addtolist("Initialization complete.");
STYPE=0;ISRUN=FALSE;/* set program state */
}/* end load_prog() */

void g_refresh(void)/* update window and check for inputs */
{
while (gtk_events_pending())/* check if something pressed on window */
 gtk_main_iteration();/* update events */
}/* end g_refresh() */

void cdrom_reset(gboolean how)
{
if(how){/* uh there is trouble, do reset */
 settolist("Stoping cdrom drive...",Erow-3);g_refresh();
 if(ioctl(cdd, CDROMSTOP)!=0) addtolist(strerror(errno));
 settolist("Reseting cdrom drive...",Erow-2);g_refresh();
 if(ioctl(cdd, CDROMRESET)!=0){ addtolist(strerror(errno));
  settolist(" !!! WARNING !!! RESET FAIL, DO MANUAL EJECT !!! WARNING !!!",\
   Erow-1);g_refresh();addtolist(" ");
  if(ISRUN) ISRUN=FALSE;}
 addtolist(" ");addtolist(" ");/* reset log position */
}else{/* do soft reset */
 if(ISSCSI){/* unlock door */
  addtolist("Unlocking cdrom door for ejecting media...");g_refresh();
  scsi_cmd.inlen=0;scsi_cmd.outlen=0;scsi_cmd.cmd[0]=0x1e; /* allow removal */
  scsi_cmd.cmd[1]=0;scsi_cmd.cmd[2]=0;scsi_cmd.cmd[3]=0;scsi_cmd.cmd[4]=0;
  scsi_cmd.cmd[5]=0;if(ioctl(cdd,SCSI_IOCTL_SEND_COMMAND,(void *)&scsi_cmd)!=0)
  addtolist(strerror(errno));}/* end if SCSII */
 addtolist("Stoping and ejecting media from cdrom drive...");
 addtolist("If after 10 seconds program not eject media, do manual eject !");
 g_refresh();
 if(ioctl(cdd, CDROMEJECT)!=0){
  addtolist("Fail to eject media from cdrom drive !");
  addtolist(strerror(errno));/* write error */
  addtolist("Doing hard reset to avoid damage of cdrom drive !");
  cdrom_reset(TRUE);/* hard reset */
 }/* end if ioctl */
 addtolist("Ejecting media from cdrom drive complete.");addtolist(" ");
}/* end else reset */
}/* end cdrom_reset() */
