/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - mymount.c - source file for testing mount points

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "scan.h"

gboolean is_mounted(void)
{
gint i=0;
gboolean test=TRUE;
FILE *f;
gchar dummy[256],s[1024];
gchar *mtab[3]={"/proc/mounts","/etc/mtab","/etc/mntab"};
/* location for mount-tab file */

while( (mtab[i]!=0)&&(test) ){/* go thru list of mtab location */
 if( (f=fopen(mtab[i],"r"))!=NULL ){/* ok file opened */
  fclose(f);test=FALSE;
 }else i++;/* file not opened */
}/* end while mtab */

if(test){/* mtab file not found */
 test=FALSE;/* default action, display error */
 addtolist("E11: Can't locate mount-tab file !");
}else{/* mtab file found, test if device mounted */
 f=fopen(mtab[i],"r");
 while (fscanf(f,"%s %s %s %s %s %s",s,dummy,dummy,dummy,dummy,dummy)>=4){
  g_readlink(s);/* read if s is link */
  if (strncmp(s,CDROM,sizeof(CDROM)-1)==0) test=TRUE;}
 fclose(f);
}/* end else if test */
return (test);
}/* end is_mounted() */

void where_mounted(gchar *pwdloc)
{
gint i=0;
gboolean test=TRUE;
FILE *f;
gchar dummy[256],s[1024];
gchar *mtab[3]={"/proc/mounts","/etc/mtab","/etc/mntab"};
/* location for mount-tab file */

while( (mtab[i]!=0)&&(test) ){/* go thru list of mtab location */
 if( (f=fopen(mtab[i],"r"))!=NULL ){/* ok file opened */
  fclose(f);test=FALSE;
 }else i++;/* file not opened */
}/* end while mtab */

if(test){/* mtab file not found */
 pwdloc[0]=0;/* no location */
 addtolist("E11: Can't locate mount-tab file !");
}else{/* mtab file found, get location of mounted device */
 f=fopen(mtab[i],"r");
 while (fscanf(f,"%s %s %s %s %s %s",s,pwdloc,dummy,dummy,dummy,dummy)>=4){
  g_readlink(s);/* read if s is link */
  if (strncmp(s,CDROM,sizeof(CDROM)-1)==0) break;
  else pwdloc[0]=0;}
 fclose(f);
}/* end else if test */
}/* end where_mounted() */
