/******************************************************************************
    Program cdscan, scaning cd media to find damage on it:
    - simage.c - source file for scaning image od device

    Copyright (C) 2000 Silvio Klaic, sklaic@student.math.hr
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
******************************************************************************/
#include <gtk/gtk.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>

#include "scan.h"
#include "help.h"
#include "interface.h"
#include "callbacks.h"

void test(void)/* test device */
{
register gint nr=1;/* number of read bytes */
gchar buf[10240];/* set size of read buffer */

while((nr>0)&& ISRUN){/* read until there is data or cancel */
 nr=read(cdd,buf,sizeof(buf));/* get data */
 totsize+=nr;scantime=time(NULL);g_refresh();
}/* end while thru device */
}/* end test() */

gboolean timecheck(gpointer dummy)
{
register gfloat perc;

perc=ldiv(ldiv(totsize,100000000).rem,100000).quot/10000.0;
if(gtk_progress_get_value(GTK_PROGRESS(fileprogres))!=perc){/* ok update data */
 if(perc<=1) gtk_progress_bar_update (GTK_PROGRESS_BAR (fileprogres), perc);
 perc=div((totsize/765460480.0)*100,1).quot;/* main progress */
 if(cursize!=div(perc,1).quot){/* percentage is changed, update */
  cursize=div(perc,1).quot;/* set new value */
  if(perc<=100.0) gtk_progress_bar_update (GTK_PROGRESS_BAR (totalprogres),\
	perc/100.0);
  sprintf(res," Scaning cd image at %ld %%, %ld bytes, ~%ld Kbytes, ~%ld\
 Mbytes\n",cursize,totsize,ldiv(totsize,1024).quot,ldiv(totsize,1048576).quot);
  logwrite(res,0,3,14);/* write status */
 }/* end if != perc */
 sprintf(res,"Scaning %9ld bytes - %2ld %%",totsize,cursize);
 settolist(res,Erow-1);
}/* end if progress change */
if(ISRUN && ISSCANING){/* ok program still runing do check */
 if(scantime+DTIME<=time(NULL)){
  logwrite("Scaning cd image fail, there are errors !\n",1,2,14);
  sprintf(res,"Error found after %ld bytes in cd image file!\n",totsize);
  logwrite(res,0,4,14);
  settolist("E14: Scaning fail, delay time expired !",Erow-1);
  ISRUN=FALSE;cdrom_reset(FALSE);
 }/* end if >delay */
}else return(FALSE);/* end if runing */
return(TRUE);
}/* end timecheck() */

void scan_image(void)/* run test and retrieve data */
{
gint stime;

addtolist("Seting up for scaning ...");cursize=1;
sprintf(res,"Starting scan on %s with estimated cd image size of 730 Mb\
 - 80 minutes.\n",CDROM);logwrite(res,1,14,14);
sprintf(res,"Aborting scan if cdrom drive not respond after %d seconds.\n",\
	DTIME);logwrite(res,1,4,14);
sprintf(res,"Starting with delay of %d seconds. (for cdrom upspining time)\n",\
	5+DTIME);logwrite(res,1,14,14);
gtk_progress_set_activity_mode(GTK_PROGRESS (fileprogres), TRUE);
scantime=time(NULL)+5;ISSCANING=TRUE;/* set time for upsining cdrom */
stime=gtk_timeout_add (100, timecheck, NULL);
test();ISSCANING=FALSE;/* do scan */
gtk_timeout_remove (stime);g_refresh();/* clean test */
gtk_progress_set_activity_mode(GTK_PROGRESS (fileprogres), FALSE);
gtk_progress_bar_update (GTK_PROGRESS_BAR (fileprogres), 0.0);
gtk_progress_bar_update (GTK_PROGRESS_BAR (totalprogres), 0.0);
if(ISRUN){/* write last status */
 logwrite("Scaning cd image complete, no errors found.\n",1,4,14);
 sprintf(res,"Total scaned %ld bytes.\n",totsize);logwrite(res,0,14,14);
 settolist("Scaning complete.",Erow-1);
}else{ /* cancel executing test */
 sprintf(res,"Scaning interupted at %ld bytes.\n",totsize);
 logwrite(res,1,4,14);settolist("Scaning interupted.",Erow-1);
}/* end else if not run */
ISRUN=FALSE;scan_button();/* return to scan input */
}/* end scan_image() */

