/*****************************************************************************
 *  conf.c: functions for retrieving options from config file.
 *  This is part of httpaccess program.
 *  Copyright (C) 2001  Silvio Klaic, sklaic@student.math.hr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>

#include "httpaccess.h"

void extrpod(char *ulaz,struct cfg_data *output)
{ /* Extract data from config file */
int i,j;

i=0;
while((ulaz[i]!='=')&&(ulaz[i]!='\0')&&(ulaz[i]!='\n')){
 output->Init_Value[i]=ulaz[i];i++;}
output->Init_Value[i]='\0';
j=i+1;i=0;
while((ulaz[i+j]!='\0')&&(ulaz[i+j]!='\n')){
 output->Value[i]=ulaz[i+j];i++;}
output->Value[i]='\0';
}/* end extrpod() */

short int read_conf_file(char cfg_loc[256])
{
struct cfg_data data;
char line[256];
FILE *f;

strcat(cfg_loc,"/.httpaccrc");
/* test if cfg file exists */
if(access(cfg_loc,R_OK)==-1){
 printf("Config file %s error:\n%s !\n",cfg_loc,strerror(errno));
 return(false);}
/* read cfg file */
if ((f=fopen(cfg_loc,"rt"))!=NULL){
 do{
  fgets(line,255,f);
  if ((line[0]!='#')&&(line[0]!=' ')&&(line[0]!='\n')&&(line[0]!='\0')){
   extrpod(line,&data);
   if(strcmp(data.Init_Value,"CHECKFILE")==0)
    strcpy(check_,data.Value);
   if(strcmp(data.Init_Value,"DATAFILE")==0)
    strcpy(data_,data.Value);
   if(strcmp(data.Init_Value,"LOGFILE")==0)
    strcpy(logfile_,data.Value);
   if(strcmp(data.Init_Value,"TMPDIR")==0)
    strcpy(tmpfile_,data.Value);
  }
  line[0]='\0';
 }while(!feof(f));
 fclose(f);
}else{
 printf("Can't open config file: %s !\n",cfg_loc);
 return(false);}
return(true);
}/* end read_conf_file() */
