/*****************************************************************************
 *  main.c: main part, uses for display help and starting program 
 *  This is part of httpaccess program.
 *  Copyright (C) 2001  Silvio Klaic, sklaic@student.math.hr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include "httpaccess.h"

short int read_conf_file(char cfg_loc[256]);
void scanlog(void);
void update(char *f_name);

int main(int argv,char *argc[])
{
int i;
FILE *f;

if((argv<2)||(strcmp(argc[1],"-h")==0)||(strcmp(argc[1],"-help")==0)){
/* no activating parametar, write usage */
 printf("Usage: %s <activating parametar>\n",argc[0]);
 printf("Version %s, activating parametars:\n\
  -h, -help    : display this help\n\
  -scan        : program scan all files in 'check' file from httpd access log\
\n  -qscan       : quiet scan mode, do not autput anything exempt errors.\n\
  html_file(s) : search html_file(s) and update number of access in it.\n",
  VER);exit(0);
}

if(!read_conf_file(getenv("HOME"))){ /* can't read config file */
 fprintf(stderr,"Woha, can't read config file, check if file is accessible for program.\n");exit(1);
}/* end if read cfg */

if(access(check_,R_OK)==-1){/* check if 'check' file can be read */
 printf("Can't read \"check\" file %s error:\n%s !\n",check_,strerror(errno));
 exit(2);}
if((f=fopen(data_,"a"))==NULL){/* check if data file can be write */
 printf("Can't write in data file %s:\n%s !\n",data_,strerror(errno));
 exit(3);}else fclose(f);
if(access(data_,R_OK)==-1){/* check if data file can be read */
 printf("Can't read data file %s:\n%s !\n",data_,strerror(errno));
 exit(3);}
strcat(tmpfile_,"/.hatf.XXXXXX");mktemp(tmpfile_);/* make tmp file */
if((f=fopen(tmpfile_,"w"))==NULL){/* check if tmp file can be write */
 printf("Can't write in temp file %s:\n%s !\n",tmpfile_,strerror(errno));
 exit(4);}else fclose(f);
if(access(tmpfile_,R_OK)==-1){/* check if data file can be read */
 printf("Can't read temp file %s:\n%s !\n",tmpfile_,strerror(errno));
 remove(tmpfile_);exit(4);}

if((strcmp(argc[1],"-scan")==0)||(strcmp(argc[1],"-qscan")==0)){/* ok do scan */
 if(argc[1][1]=='q') Q_OPT=1; else Q_OPT=0;/* quiet option */
 if(access(logfile_,R_OK)==-1){/* check if 'check' file can be read */
  printf("Can't read httpd log file %s:\n%s !\n",logfile_,strerror(errno));
  remove(tmpfile_);exit(5);/* clean and exit */
 }else scanlog();/* ok continue */
}else{/* go thru file , search and update accessed files */
 for(i=1;i<argv;i++){/* go thru files */
  if(access(argc[i],R_OK | W_OK)==-1){/* check if file can be read & write */
   printf("\rSkipping file %s:\n%s !\n",argc[i],strerror(errno));fflush(NULL);
  }else{/* all ok do read and modify */
   printf("\rUpdating file %s ...",argc[i]);fflush(NULL);update(argc[i]);
  }/* end else if access */
 }/* end for i */
}/* end else if -scan */

remove(tmpfile_);/* clean */
return(0);
}/* end main() */
