/*****************************************************************************
 *  scan.c: here are functions for scaning log file and writing database
 *  This is part of httpaccess program.
 *  Copyright (C) 2001,2002  Silvio Klaic, sklaic@student.math.hr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

#include "httpaccess.h"

short int isinline(char *lin, char *name);
void get_date(char *lin, char *newdate);

void scanlog(void)
{
char wrd[512],lin[1024];
struct filek {
 char fileloc[512],time[25];
 unsigned int count;
} finfo;
char *b,ch[4]={"..."};
FILE *f,*g;

f=fopen(check_,"r");/* open check file */
do{/* go thru log file */
 wrd[0]=0;fgets(wrd,512,f);wrd[strlen(wrd)-1]=0;/* read line */
 if(wrd[0]!=0){/* ok somethin to look for */
  strcpy(finfo.fileloc,wrd);strcpy(finfo.time,"0000/00/00:00:00:00");
  finfo.count=0;/* set default rezults */
  g=fopen(data_,"r");/* open data file */
  do{/* go thru file */
   lin[0]=0;fgets(lin,1024,g);lin[strlen(lin)-1]=0;/* read line */
   if(strcmp(lin,wrd)==0){/* found match, get date and count */
    lin[0]=0;fgets(lin,1024,g);lin[strlen(lin)-1]=0;/* read date */
    strcpy(finfo.time,lin);/* copy date to info structure */
    lin[0]=0;fgets(lin,1024,g);lin[strlen(lin)-1]=0;/* read hit count */
    finfo.count=atoi(lin);/* copy count to info structure */
   }/* end if strcmp */
  }while(!feof(g)); fclose(g);/* end go thru file */
  g=fopen(logfile_,"r");/* open log file */
  if(!Q_OPT){/* no quiet option write status */
   if(strlen(finfo.fileloc)<=40){/* line ok write full file location */
    b=&finfo.fileloc[0];ch[0]=0;
   }else{/* file name too long short it */
    b=&finfo.fileloc[strlen(finfo.fileloc)-40];ch[0]='.';}
   printf("\rScaning for %s%s, %d found so far.",ch,b,finfo.count);fflush(NULL);
  }/* end if there's no quiet option */
  do{/* go thru file */
   lin[0]=0;fgets(lin,1024,g);lin[strlen(lin)-1]=0;/* read line */
   if(isinline(lin,finfo.fileloc)){/* ok found file in line */
    get_date(lin,wrd);/* get date */
    if(strcmp(wrd,finfo.time)>0){/* ok new date, save it */
     if(!Q_OPT){/* no quiet option write status */
      if(strlen(finfo.fileloc)<=40)/* line ok write full file location */
       b=&finfo.fileloc[0];
      else/* file name too long short it */
       b=&finfo.fileloc[strlen(finfo.fileloc)-40];
      printf("\rScaning for %s%s, %d found so far.",ch,b,finfo.count);
      fflush(NULL);}/* end if there's no quiet option */
     strcpy(finfo.time,wrd);finfo.count++;/* update structure */
    }/* end if strcmp date */
   }/* end if isinline */
  }while(!feof(g));fclose(g);/* end go thru file */
  if(!Q_OPT){/* no quiet option write status */
   if(strlen(finfo.fileloc)<=40)/* line ok write full file location */
    b=&finfo.fileloc[0];
   else/* file name too long short it */
    b=&finfo.fileloc[strlen(finfo.fileloc)-40];
   printf("\r%79s\rScaning %s%s complete, total %d hits.\n"," ",ch,b,
	finfo.count);fflush(NULL); 
  }/* end if there's no quiet option */
  g=fopen(tmpfile_,"a");/* open file for append */
  fprintf(g,"%s\n%s\n%d\n",finfo.fileloc,finfo.time,finfo.count);
  fclose(g);/* write structure to file and close tmp file */
 }/* end if not empty line */
}while(!feof(f));
fclose(f);/* close file */
f=fopen(tmpfile_,"r");g=fopen(data_,"w");/* open files */
while(!feof(f)){/* go thru file */
 lin[0]=0;fgets(lin,1024,f);fputs(lin,g);}/* copy from tmp to data */
fclose(g);fclose(f);fflush(NULL);/* close all files */
}/* end scanlog() */
