; micek/theme.jl

;; Copyright (C) 2001 Silvio Klaic <sklaic@student.math.hr>
;; This theme is addon to micek-gtk theme.

(let*
    ;; Update window title pixel length
    ((title-width
      (lambda (w)
	(let
	    ((w-width (car (window-dimensions w))))
	  (max 0 (min (- w-width 100) (text-width (window-name w)))))))
     
     ;; 2x6
     (bottom-images (list (make-image "bottom_inactive.png")
     			  (make-image "bottom_active.png")))
     ;; 6x27
     (top-left-images (make-image "top_left.png"))
     (top-left-shaped-images (make-image "top_left_s.png"))

     ;; 19x19
     (top-blue-images (list (make-image "top_inactive.png")
			    (make-image "top_active.png")))
     ;; 12x19
     (top-curves-images (list (make-image "top_right_inactive.png")
			      (make-image "top_right_active.png")))
     (top-curves1-images (list (make-image "top_left_inactive.png")
			      (make-image "top_left_active.png")))
     ;; 19x19
     (top-grey-images (make-image "top_normal.png"))

     ;; 7x19
     (top-right-images (make-image "top_right.png"))
     (top-right-shaped-images (make-image "top_right_s.png"))

     ;; 6x6
     (bottom-left-images (list (make-image "bl_inactive.png")
     			       (make-image "bl_active.png")))
     ;; 6x6
     (bottom-right-images (list (make-image "br_inactive.png")
     				(make-image "br_active.png")))
     ;; 17x16
     (close-images (list (make-image "close_normal.png")
			 (make-image "close_active.png") nil
			 (make-image "close_clicked.png")))
     ;; 17x16
     (maximize-images (list (make-image "maximize_normal.png")
			    (make-image "maximize_active.png") nil
			    (make-image "maximize_clicked.png")))
     ;; 17x16
     (iconify-images (list (make-image "minimize_normal.png")
			   (make-image "minimize_active.png") nil
			   (make-image "minimize_clicked.png")))
     ;; 17x16
     (menu-images (list (make-image "menu_normal.png")
			(make-image "menu_active.png") nil
			(make-image "menu_clicked.png")))
     ;; 6x19
     (left-images (list (make-image "left_inactive.png")
     			(make-image "left_active.png")))
     ;; 6x19
     (right-images (list (make-image "right_inactive.png")
     			 (make-image "right_active.png")))
     ;; 18x17
     (t-close-images (list (make-image "t_close_normal.png")
			   (make-image "t_close_active.png") nil
			   (make-image "t_close_clicked.png")))
     ;; 5x19
     (t-left-images (list (make-image "t_left_inactive.png")
     			  (make-image "t_left_active.png")))
     ;; 18x10
     (t-right-images (make-image "t_right.png"))

     ;; 19x5
     (t-top-images (list (make-image "t_top_inactive.png")
     			 (make-image "t_top_active.png")))
     ;; 19x5
     (t-bottom-images (list (make-image "t_bottom_inactive.png")
     			    (make-image "t_bottom_active.png")))
     ;; 5x5
     (t-top-left-images (list (make-image "t_tl_inactive.png")
     			      (make-image "t_tl_active.png")))
     ;; 5x5
     (t-bottom-left-images (list (make-image "t_bl_inactive.png")
     				 (make-image "t_bl_active.png")))
     ;; 18x5
     (t-top-right-images (make-image "t_top_right.png"))

     ;; 18x5
     (t-top-right-s-images (make-image "t_top_right_s.png"))

     ;; 18x5
     (t-bottom-right-images (make-image "t_bottom_right.png"))

     ;; 18x5
     (t-bottom-right-s-images (make-image "t_bottom_right_s.png"))

     ;; frame layout
     (frame `(((background . ,top-left-images)
	       (left-edge . -6)
	       (top-edge . -19)
	       (class . top-left-corner))

	      ;; top blue
	      ((background . ,top-blue-images)
	       (foreground . "black")
	       (text . ,window-name)
	       (x-justify . center)
	       (y-justify . center)
	       (top-edge . -19)
	       (left-edge . 31)
	       (width . ,(lambda (w) (+ (title-width w) 13)))
	       (class . title))

	      ;; menu button
	      ((background . ,menu-images)
	       (top-edge . -19)
	       (left-edge . 0)
	       (class . menu-button))

	      ;; top right curves
	      ((background . ,top-curves-images)
	       (left-edge . ,(lambda (w) (+ (title-width w) 44)))
	       (top-edge . -19)
	       (class . title))

	      ;; top left curves
	      ((background . ,top-curves1-images)
	       (left-edge . ,(lambda (w) (+ 19)))
	       (top-edge . -19)
	       (class . title))

	      ;; top grey
	      ((background . ,top-grey-images)
	       (top-edge . -19)
	       (left-edge . ,(lambda (w) (+ (title-width w) 56)))
	       (right-edge . 52)
	       (class . title))

	      ;; left border
	      ((background . ,left-images)
	       (left-edge . -6)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . left-border))

	      ;; top-right corner
	      ((background . ,top-right-images)
	       (right-edge . -6)
	       (top-edge . -19)
	       (class . top-right-corner))

	      ;; right border
	      ((background . ,right-images)
	       (right-edge . -6)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . right-border))

	      ;; bottom border
	      ((background . ,bottom-images)
	       (left-edge . 0)
	       (right-edge . 0)
	       (bottom-edge . -6)
	       (class . bottom-border))

	      ;; bottom-left corner
	      ((background . ,bottom-left-images)
	       (left-edge . -6)
	       (bottom-edge . -6)
	       (class . bottom-left-corner))

	      ;; bottom-right corner
	      ((background . ,bottom-right-images)
	       (right-edge . -6)
	       (bottom-edge . -6)
	       (class . bottom-right-corner))

	      ;; iconify button
	      ((background . ,iconify-images)
	       (right-edge . 35)
	       (top-edge . -19)
	       (class . iconify-button))

	      ;; maximize button
	      ((background . ,maximize-images)
	       (right-edge . 18)
	       (top-edge . -19)
	       (class . maximize-button))

	      ;; delete button
	      ((background . ,close-images)
	       (right-edge . 1)
	       (top-edge . -19)
	       (class . close-button))))

       (shaped-frame `(((background . ,top-left-shaped-images)
			(left-edge . -6)
			(top-edge . -19)
			(height . 19)
			(class . top-left-corner))

		       ;; top blue
		       ((background . ,top-blue-images)
			(foreground . "black")
			(text . ,window-name)
			(x-justify . 4)
			(y-justify . center)
			(top-edge . -19)
			(left-edge . 19)
			(width . ,(lambda (w) (+ (title-width w) 13)))
			(class . title))

		       ;; menu button
		       ((background . ,menu-images)
			(top-edge . -19)
			(left-edge . 0)
			(class . menu-button))

		       ;; top curves
		       ((background . ,top-curves-images)
			(left-edge . ,(lambda (w) (+ (title-width w) 32)))
			(top-edge . -19)
			(class . title))

		       ;; top grey
		       ((background . ,top-grey-images)
			(top-edge . -19)
			(left-edge . ,(lambda (w) (+ (title-width w) 44)))
			(right-edge . 52)
			(class . title))

		       ;; top-right corner
		       ((background . ,top-right-shaped-images)
			(right-edge . -6)
			(top-edge . -19)
			(height . 19)
			(class . top-right-corner))

		       ;; iconify button
		       ((background . ,iconify-images)
			(right-edge . 35)
			(top-edge . -19)
			(class . iconify-button))

		       ;; maximize button
		       ((background . ,maximize-images)
			(right-edge . 18)
			(top-edge . -19)
			(class . maximize-button))

		       ;; delete button
		       ((background . ,close-images)
			(right-edge . 1)
			(top-edge . -19)
			(class . close-button))))

       (transient-frame `(((background . ,t-top-left-images)
			   (left-edge . -5)
			   (top-edge . -5)
			   (class . top-left-corner))

			  ;;top-right corner
			  ((background . ,t-top-right-images)
			   (right-edge . -18)
			   (top-edge . -5)
			   (class . top-right-corner))

			  ;;title border
			  ((background . ,t-top-images)
			   (left-edge . 0)
			   (right-edge . -1)
			   (top-edge . -5)
			   (class . top-border))

			  ;; left border
			  ((background . ,t-left-images)
			   (left-edge . -5)
			   (top-edge . 1)
			   (bottom-edge . 1)
			   (class . left-border))

			  ;; right border
			  ((background . ,t-right-images)
			   (right-edge . -18)
			   (top-edge . 0)
			   (bottom-edge . 0)
			   (class . title))

			  ;; bottom border
			  ((background . ,t-bottom-images)
			   (left-edge . 0)
			   (right-edge . -1)
			   (bottom-edge . -5)
			   (class . bottom-border))

			  ;; bottom-left corner
			  ((background . ,t-bottom-left-images)
			   (left-edge . -5)
			   (bottom-edge . -5)
			   (class . bottom-left-corner))

			  ;; bottom-right corner
			  ((background . ,t-bottom-right-images)
			   (right-edge . -18)
			   (bottom-edge . -5)
			   (class . bottom-right-corner))

			  ;; delete button
			  ((background . ,t-close-images)
			   (right-edge . -18)
			   (top-edge . 2)
			   (class . close-button))))

       (shaped-transient-frame `(((background . ,t-top-right-s-images)
				  (right-edge . -18)
				  (top-edge . -5)
				  (class . top-right-corner))

				 ;; right border
				 ((background . ,t-right-images)
				  (right-edge . -18)
				  (top-edge . 0)
				  (bottom-edge . 0)
				  (class . title))

				 ;; bottom-right corner
				 ((background . ,t-bottom-right-s-images)
				  (right-edge . -18)
				  (bottom-edge . -5)
				  (class . bottom-right-corner))

				 ;; delete button
				 ((background . ,t-close-images)
				  (right-edge . -18)
				  (top-edge . 1)
				  (class . close-button)))))
  
  (add-frame-style 'micek
		   (lambda (w type)
		     (cond ((eq type 'shaped)
			    shaped-frame)
			   ((eq type 'transient)
			    transient-frame)
			   ((eq type 'shaped-transient)
			    shaped-transient-frame)
			   ((eq type 'unframed)
			    nil-frame)
			   (t
			    frame))))

  (call-after-property-changed
   'WM_NAME (lambda ()
	      (rebuild-frames-with-style 'micek))))

;; end of theme file
