/* color.c: manipulate with colors for program tmount.
    Copyright (C) 1998 1999  Silvio Klaic, sklaic@student.math.hr

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
    **************************************************************************/

#include <curses.h>

#include "color.h"

/**************************** initialize colors *********************/
void InitColors(void)
{
    start_color();
    init_pair(MENU_COLOR, COLOR_CYAN, COLOR_BLUE);
    init_pair(KEY_COLOR, COLOR_YELLOW, COLOR_BLACK);/* use bold */
    init_pair(TEXT_COLOR, COLOR_WHITE, COLOR_BLACK);
    init_pair(STDMSG_COLOR, COLOR_GREEN, COLOR_BLACK);/* use bold */
    init_pair(ERRMSG_COLOR, COLOR_RED, COLOR_BLACK);/* use bold */
    init_pair(ACTTXT_COLOR, COLOR_CYAN, COLOR_MAGENTA);/* use bold */
    init_pair(ACTMSG1_COLOR, COLOR_GREEN, COLOR_MAGENTA);/* use bold */
    init_pair(ACTMSG2_COLOR, COLOR_YELLOW, COLOR_MAGENTA);/* use bold */
    init_pair(ACTMSG_COLOR, COLOR_CYAN, COLOR_BLACK);/* use bold */
    /* for select item use STDMSG_COLOR & ERRMSG_COLOR with A_REVERSE */
}

/****************** write text in window at position *****************/
void printclr(WINDOW *c_win,short int DEF_CLR,int DEF_FLAG,int X_POS,int Y_POS,char *TEXT)
{
wattrset(c_win, COLOR_PAIR(DEF_CLR) | DEF_FLAG);
wmove(c_win, Y_POS, X_POS);
waddstr(c_win, TEXT);
}
