/* list.c: writes on screen refreshed data for program tmount.
    Copyright (C) 1998 1999  Silvio Klaic, sklaic@student.math.hr

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
    **************************************************************************/

#include <stdio.h>
#include <curses.h>

#include "tmount.h"

void printclr(WINDOW *c_win,short int DEF_CLR,int DEF_FLAG,int X_POS,int Y_POS,char *TEXT);

/*************** Write title and instructions to screen *****************/
void WriteInitScreen(void)
{
printclr(stdscr,MENU_COLOR,A_NORMAL,8,1," File system             Mount point       FS type         Status ");
printclr(stdscr,TEXT_COLOR,A_NORMAL,8,20,"Use             to move over menu.Press       to use given action.");
printclr(stdscr,KEY_COLOR,A_BOLD,12,20,"cursor keys");
printclr(stdscr,KEY_COLOR,A_BOLD,48,20,"enter");
printclr(stdscr,KEY_COLOR,A_BOLD,7,21,"? key");
printclr(stdscr,TEXT_COLOR,A_NORMAL,13,21,"for help.      for quit program.      run e2fsck.      eject.");
printclr(stdscr,KEY_COLOR,A_BOLD,22,21,"Q key");
printclr(stdscr,KEY_COLOR,A_BOLD,45,21,"X key");
printclr(stdscr,KEY_COLOR,A_BOLD,62,21,"E key");
}

/********************** Write to screen data menu ***********************/
void DataRefresh(int kojije)
{
int i,j,k;
char lin[128];

for(i=3+kojije;i<=18+kojije;i++){
  move(i-kojije,5);refresh();
  if (kojije<=15){
    j=kojije;k=15-kojije;}
  else{
    j=15;k=0;}
  switch (data[i-3-j].stat){
    case 0 :
	    if (i-18+k==kojije){
	      sprintf(lin,"%12s %23s %13s %15s",data[i-3-j].dev,data[i-3-j].dir,data[i-3-j].typ,"Not mounted. ");
	      printclr(stdscr,STDMSG_COLOR,A_REVERSE,8,i-kojije,lin);
	      printclr(stdscr,ACTTXT_COLOR,A_BLINK | A_BOLD,24,2,"          Action :               ");
	      printclr(stdscr,ACTMSG1_COLOR,A_BOLD,43,2,"MOUNT");
	    }else
	      if (data[i-3-j].dev[0]!='\0'){
	       sprintf(lin,"%12s %23s %13s %15s",data[i-3-j].dev,data[i-3-j].dir,data[i-3-j].typ,"Not mounted. ");
	       printclr(stdscr,STDMSG_COLOR,A_NORMAL,8,i-kojije,lin);}
	    break;
    case 1 :
	    if (i-18+k==kojije){
	      sprintf(lin,"%12s %23s %13s %15s",data[i-3-j].dev,data[i-3-j].dir,data[i-3-j].typ," Mounted !  ");
	      printclr(stdscr,ERRMSG_COLOR,A_REVERSE,8,i-kojije,lin);
	      printclr(stdscr,ACTTXT_COLOR,A_BLINK | A_BOLD,24,2,"         Action :                ");
	      printclr(stdscr,ACTMSG2_COLOR,A_BOLD,42,2,"UNMOUNT");
	    }else
	      if (data[i-3-j].dev[0]!='\0'){
	       sprintf(lin,"%12s %23s %13s %15s",data[i-3-j].dev,data[i-3-j].dir,data[i-3-j].typ," Mounted !  ");
	       printclr(stdscr,ERRMSG_COLOR,A_BOLD,8,i-kojije,lin);}
	    break;
    case 2 :
	    if (i-18+k==kojije){
	      sprintf(lin,"%12s %23s %13s %15s",data[i-3-j].dev,data[i-3-j].dir,data[i-3-j].typ,"Unmount first.");
	      printclr(stdscr,ACTMSG_COLOR,A_REVERSE,8,i-kojije,lin);
	      printclr(stdscr,ACTTXT_COLOR,A_BLINK | A_BOLD,24,2," Action :                        ");
	      printclr(stdscr,ACTTXT_COLOR,A_BOLD,34,2,"NONE (Allredy mounted)");
	    }else
	      if (data[i-3-j].dev[0]!='\0'){
	        sprintf(lin,"%12s %23s %13s %15s",data[i-3-j].dev,data[i-3-j].dir,data[i-3-j].typ,"Unmount first.");
		printclr(stdscr,ACTMSG_COLOR,A_BOLD,8,i-kojije,lin);}
	    break;
  }
}
refresh();
}

/******************** writes log files if there exists *********************/
void test_logs(char *which_program,WINDOW *p_win)
{
WINDOW *s_win;
char line[256],i;
unsigned long size;
FILE *f;

s_win=subwin(stdscr,12,64,5,9);/* create window for message */
touchwin(s_win);wclear(s_win);wborder(p_win,0,0,0,0,0,0,0,0);wrefresh(s_win);
f=fopen(log_location,"rt");/* get file size of standard log */
fseek(f,1,SEEK_END);size=ftell(f)-1;rewind(f);
if(size<=0) fclose(f);/* there is no message in standard log */
else{/* there is message in standard log */
 sprintf(line," Standard message from %s: ",which_program);
 i=0;printclr(p_win,TEXT_COLOR,A_BOLD,17,0,line);
 while(!feof(f)) {
  line[0]=0;fgets(line,255,f);
  printclr(s_win,STDMSG_COLOR,A_NORMAL,0,i,line);i++;
  if(i>=12){/* there is more text in log */
   printclr(p_win,TEXT_COLOR,A_NORMAL,17,13," Press any key to continue ... ");
   printclr(p_win,TEXT_COLOR,A_BLINK,24,13,"any key");
   printclr(p_win,TEXT_COLOR,A_NORMAL,47,13," ");
   wrefresh(s_win);wrefresh(p_win);getch();i=1;wclear(s_win);
   printclr(s_win,STDMSG_COLOR,A_NORMAL,0,0,line);wrefresh(s_win);}
 }
 fclose(f);
 printclr(p_win,TEXT_COLOR,A_BOLD,17,13," Press any key to continue ... ");
 wrefresh(s_win);wrefresh(p_win);getch();}/* end else stand log */

f=fopen(err_location,"rt");/* get file size of error log */
fseek(f,1,SEEK_END);size=ftell(f)-1;rewind(f);
if(size<=0) fclose(f);/* there is no message in error log */
else{/* there is message in error log */
 sprintf(line," Error message from %s: ",which_program);
 i=0;printclr(p_win,TEXT_COLOR,A_BOLD,18,0,line);
 while(!feof(f)) {
  line[0]=0;fgets(line,255,f);
  printclr(s_win,ERRMSG_COLOR,A_BOLD,0,i,line);i++;
  if(i>=12){/* there is more text in log */
   printclr(p_win,TEXT_COLOR,A_NORMAL,17,13," Press any key to continue ... ");
   printclr(p_win,TEXT_COLOR,A_BLINK,24,13,"any key");
   printclr(p_win,TEXT_COLOR,A_NORMAL,47,13," ");
   wrefresh(s_win);wrefresh(p_win);getch();i=1;wclear(s_win);
   printclr(s_win,ERRMSG_COLOR,A_BOLD,0,0,line);wrefresh(s_win);}
  }
 fclose(f);
 printclr(p_win,TEXT_COLOR,A_BOLD,17,13," Press any key to continue ... ");
 wrefresh(s_win);wrefresh(p_win);getch();}/* end else error log */
delwin(s_win);/* destroy window for messeges */
}
