/* main.c: main functions for tmount program.
    Copyright (C) 1998 1999  Silvio Klaic, sklaic@student.math.hr

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
    **************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <curses.h>
#include <unistd.h>

#include "tmount.h"

void extrpod(char ulaz[255],int koji);
int mtab_update(char dest[255],int cpos);
void DataRefresh(int kojije);
void action_for(int broj);
void test_logs(char *which_program,WINDOW *p_win);
void printclr(WINDOW *c_win,short int DEF_CLR,int DEF_FLAG,int X_POS,int Y_POS,char *TEXT);
void InitColors(void);
void WriteInitScreen(void);

/********************* action for other functions ************************/
void action_in(char what,int stat)
{
WINDOW *f_win;
int i;
char estr[80],line[255];

f_win=subwin(stdscr,14,66,4,8);/* create window for message */
touchwin(f_win);wclear(f_win);wborder(f_win,0,0,0,0,0,0,0,0);
printclr(f_win,TEXT_COLOR,A_BOLD,28,0," Wait ... ");wrefresh(f_win);
switch (what) {
  case 0 :
     if ((data[stat].stat==0)&&(strcmp(data[stat].typ,"ext2")==0)){
      sprintf(line,"e2fsck -p -f -v -t %s > %s 2> %s",data[stat].dev,log_location,err_location);
      sprintf(estr," Runing e2fsck for %s on %s (%s)! ",data[stat].typ,data[stat].dev,data[stat].dir);
      printclr(f_win,TEXT_COLOR,A_BOLD,5,0,estr);
      printclr(f_win,KEY_COLOR,A_BOLD | A_BLINK,25,13," Please wait ... ");
      printclr(f_win,KEY_COLOR,A_BOLD,41,13," ");
      wrefresh(f_win);system(line);test_logs("e2fsck",f_win);
     }else{ /* can't run e2fsck */
       if(data[stat].stat==0){/* partition not ext2 */
	printclr(f_win,TEXT_COLOR,A_NORMAL,15,4,"         Can't run e2fsck !");
	printclr(f_win,KEY_COLOR,A_BOLD,15,5,"    Partition is not ext2 type.");
	printclr(f_win,TEXT_COLOR,A_NORMAL,15,6,"  Only ext2 partition can be used.");
	printclr(f_win,TEXT_COLOR,A_NORMAL,15,7,"      For details see man page.");
       }else{/* partition mounted */
        printclr(f_win,TEXT_COLOR,A_NORMAL,15,4,"         Can't run e2fsck !");
        printclr(f_win,KEY_COLOR,A_BOLD,15,5,"    Partition is alredy mounted.");
        printclr(f_win,TEXT_COLOR,A_NORMAL,15,6,"Unmount partition and run e2fsck again.");
        printclr(f_win,TEXT_COLOR,A_NORMAL,15,7,"      For details see man page.");}
      halfdelay(10);for(i=9;i>=1;i--){
      sprintf(estr," Closing window in %d ... ",i);
      printclr(f_win,KEY_COLOR,A_BOLD,22,13,estr);wrefresh(f_win);
      if(getch()!=-1) i=0;} nocbreak();cbreak();
     } break;
  case 1 :
     if (data[stat].stat==0){
      if((data[stat].dev[strlen(data[stat].dev)-1]<'0')||(data[stat].dev[strlen(data[stat].dev)-1]>'9')){
       sprintf(line,"eject %s > %s 2> %s",data[stat].dev,log_location,err_location);
       system(line);test_logs("eject",f_win);clear();WriteInitScreen();
      }else{
       printclr(f_win,TEXT_COLOR,A_NORMAL,19,4,"      Can't run eject !");
       printclr(f_win,KEY_COLOR,A_BOLD,19,5,"    Cannot eject partition !");
       printclr(f_win,TEXT_COLOR,A_NORMAL,19,6,"   For details see man page .");
       halfdelay(10);for(i=9;i>=1;i--){
       sprintf(estr," Closing window in %d ... ",i);
       printclr(f_win,KEY_COLOR,A_BOLD,22,13,estr);wrefresh(f_win);
       if(getch()!=-1) i=0;} nocbreak();cbreak();
      }
     }else{ /* partition is mounted */
      printclr(f_win,TEXT_COLOR,A_NORMAL,17,4,"       Can't run eject !");
      printclr(f_win,KEY_COLOR,A_BOLD,17,5,"    Device is alredy mounted.");
      printclr(f_win,TEXT_COLOR,A_NORMAL,17,6,"Unmount device and run eject again.");
      printclr(f_win,TEXT_COLOR,A_NORMAL,17,7,"     For details see man page.");
      halfdelay(10);for(i=9;i>=1;i--){
      sprintf(estr," Closing window in %d ... ",i);
      printclr(f_win,KEY_COLOR,A_BOLD,22,13,estr);wrefresh(f_win);
      if(getch()!=-1) i=0;} nocbreak();cbreak();
     } break;
  case 2 :
     printclr(f_win,TEXT_COLOR,A_BOLD,26,0," About tmount ");
     sprintf(estr,"Tmount v%s",P_VER);
     printclr(f_win,TEXT_COLOR,A_BOLD,27,3,estr);
     sprintf(estr,"By %s %s.",P_NAME,P_DATE);
     printclr(f_win,TEXT_COLOR,A_NORMAL,8,4,estr);
     sprintf(estr,"Color %s detected !", (has_colors())? "successful" : "not");
     printclr(f_win,TEXT_COLOR,A_NORMAL,23,5,estr);
     printclr(f_win,ACTMSG_COLOR,A_BOLD,13,7,"Tmount comes with ABSOLUTELY NO WARRANTY.");
     printclr(f_win,ACTMSG_COLOR,A_NORMAL,5,8,"This is free software, and you are welcome to redistribute");
     printclr(f_win,ACTMSG_COLOR,A_NORMAL,17,9,"it under certain conditions see");
     printclr(f_win,ACTMSG_COLOR,A_NORMAL,15,10,"/usr/doc/tmount/COPYING for details.");
     halfdelay(10);for(i=19;i>=1;i--){
     sprintf(estr," Closing window in %d ... ",i);
     printclr(f_win,KEY_COLOR,A_BOLD,22,13,estr);wrefresh(f_win);
     if(getch()!=-1) i=0;} nocbreak();cbreak();
     break;
  default :
     printclr(f_win,TEXT_COLOR,A_BOLD,27,0," Short help ");
     printclr(f_win,KEY_COLOR,A_BOLD,2,2,"Cursor keys and h,j,k,l");
     printclr(f_win,TEXT_COLOR,A_NORMAL,25,2," moves you thru the list of devices.");
     printclr(f_win,KEY_COLOR,A_BOLD,2,3,"Enter key");
     printclr(f_win,TEXT_COLOR,A_NORMAL,11,3," use given action for mount or umount selected device.");
     printclr(f_win,KEY_COLOR,A_BOLD,2,4,"^L or r key");
     printclr(f_win,TEXT_COLOR,A_NORMAL,13,4," make full refresh of screen (redraw screen).");
     printclr(f_win,KEY_COLOR,A_BOLD,2,5,"E key");
     printclr(f_win,TEXT_COLOR,A_NORMAL,7,5," ejects CDROM or floppy disk.");
     printclr(f_win,KEY_COLOR,A_BOLD,2,6,"? key");
     printclr(f_win,TEXT_COLOR,A_NORMAL,7,6," display this short help.");
     printclr(f_win,KEY_COLOR,A_BOLD,2,7,"V key");
     printclr(f_win,TEXT_COLOR,A_NORMAL,7,7," write about and version informations.");
     printclr(f_win,KEY_COLOR,A_BOLD,2,8,"X key");
     printclr(f_win,TEXT_COLOR,A_NORMAL,7,8," runs e2fsck for check errors on selected device.");
     printclr(f_win,KEY_COLOR,A_BOLD,2,9,"Q key");
     printclr(f_win,TEXT_COLOR,A_NORMAL,7,9," for exit from this program.");
     printclr(f_win,KEY_COLOR,A_BOLD,20,11,"For details see man page.");
     printclr(f_win,TEXT_COLOR,A_BOLD,17,13," Press any key to continue ... ");
     wrefresh(f_win);getch();break;
}
delwin(f_win);/* destroy window for messeges */
}

/**************************** main program *******************************/
void main ()
{
char ch,line[255],home[80];
int i,j;
FILE *f;

initscr();
InitColors();
cbreak();
noecho();
/* Get home dir and make location for conf file in home directory */
if (getenv("HOME")!=NULL)
	strcpy(home,getenv("HOME"));
strcat(home,"/.tmountrc");
/* read cfg file .tmountrc in home dir or in /etc */
if ( ((f=fopen(home,"r"))!=NULL)||((f=fopen("/etc/tmountrc","r"))!=NULL)){
i=0;
do{
   fgets(line,255,f);
   if ((line[0]!='#')&&(line[0]!=' ')&&(line[0]!='\n')&&(line[0]!='\0')){
	extrpod(line,i);
	if (strcmp(data[i].dev,"Mount_Tab")==0){
		strcpy(M_TAB,data[i].dir);
		i--;}
	i++;}
   line[0]='\0';
}while (!feof(f));
fclose(f);
}else{
 printf("Can't open config file : %s or default : /etc/tmountrc !\n\rCan't continue !\n\r",home);
 endwin();
 exit(0);}
/* after sucess reading config file create error logs in /tmp */
strcpy(log_location,"/tmp/.tm.log.XXXXXX");mktemp(log_location);
strcpy(err_location,"/tmp/.tm.err.XXXXXX");mktemp(err_location);
if((f=fopen(log_location,"wb"))==NULL){
 printf("Can't create standard log file : %s\n\rCan't continue !\n\r",log_location);
 endwin();exit(1);/* fail to create temp log file */
}else fclose(f);
if((f=fopen(err_location,"wb"))==NULL){
 printf("Can't create error log file : %s\n\rCan't continue !\n\r",err_location);
 remove(log_location);endwin();exit(1);/* fail to create error temp log file */
}else fclose(f);

/* Reads Mount tab to determinate mounted devices */
kraj1=i;
kraj2=mtab_update(M_TAB,kraj1);
if (kraj2==-1){
 printf("Failed to read %s !\n\rCan't continue !\n\r",M_TAB);
 remove(log_location);remove(err_location);endwin();
 exit(0);}/* can't read mtab file */

/* begin of loop for commands */
j=0;ch=0;WriteInitScreen();/* make init of screen */
while ((ch!=113)&&(ch!=81)){
	DataRefresh(j); /* write list of mounted points */
	ch=getch();
	if (ch==27){ /* escape sign for cursors on keyboard */
	  ch=getch();
	  if (ch==91){ /* ansi char before cursor sign */
	    ch=getch();
	    if ((ch==66)||(ch==68))
	      j++;
	    if ((ch==65)||(ch==67))
	      j--;
	  }
	}
	if ( (ch=='j')||(ch=='h') ) j++;
	if ( (ch=='k')||(ch=='l') ) j--;
	if (ch=='\n'){/* runs mount/umount */
	  action_for(j);clear();WriteInitScreen();}
	if ((ch=='x')||(ch=='X')){/* runs e2fsck */
	  action_in(0,j);clear();WriteInitScreen();}
	if ((ch=='e')||(ch=='E')){/* runs eject */
	  action_in(1,j);clear();WriteInitScreen();}
	if ((ch=='v')||(ch=='V')){/* display version info */
	  action_in(2,0);clear();WriteInitScreen();}
	if ((ch==12)||(ch=='r')||(ch=='R')){
	  clear();WriteInitScreen();}/* refresh screen */
	if (ch=='?'){ /* show help */
	  action_in(3,0);clear();WriteInitScreen();}
	if (j>=kraj2)
	  j=0;
	if (j<0)
	  j=kraj2-1;
}
remove(log_location);remove(err_location);endwin();
}
