/* mount.c: activates functions for mounting/unmounting.    
    Copyright (C) 1998 1999  Silvio Klaic, sklaic@student.math.hr

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
    **************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <curses.h>
#include <unistd.h>

#include "tmount.h"

int mtab_update(char dest[255],int cpos);
void test_logs(char *which_program,WINDOW *p_win);
void printclr(WINDOW *c_win,short int DEF_CLR,int DEF_FLAG,int X_POS,int Y_POS,char *TEXT);

/********************** Function for selected action ******************/
void action_for(int broj)
{
WINDOW *f_win;
int i;
char exestr[255];

f_win=subwin(stdscr,14,66,4,8);/* create window for message */
touchwin(f_win);wclear(f_win);wborder(f_win,0,0,0,0,0,0,0,0);
printclr(f_win,TEXT_COLOR,A_BOLD,28,0," Wait ... ");wrefresh(f_win);
switch (data[broj].stat) {
  case 0 :
	  if (data[broj].typ[0]!='\0')
	   sprintf(exestr,"mount %s %s -t %s > %s 2> %s",data[broj].dev,data[broj].dir,data[broj].typ,log_location,err_location);
	  else
	    sprintf(exestr,"mount %s %s > %s 2> %s",data[broj].dev,data[broj].dir,log_location,err_location);
	  break;
  case 1 :
	  sprintf(exestr,"umount %s  > %s 2> %s",data[broj].dev,log_location,err_location);
	  data[broj].stat=0;
	  break;
  case 2 :
	  exestr[0]='\0';
	  break;
}
if (exestr[0]!='\0') system(exestr);
else{
  printclr(f_win,KEY_COLOR,A_BOLD,15,4,"       Device is alredy mounted !");
  printclr(f_win,ACTMSG_COLOR,A_NORMAL,15,5,"      Unmount it first from other");
  printclr(f_win,ACTMSG_COLOR,A_NORMAL,15,6,"     mount point, then mount it to");
  printclr(f_win,ACTMSG_COLOR,A_NORMAL,15,7,"           this mount point .");
  halfdelay(10);
  for(i=9;i>=1;i--){sprintf(exestr," Closing window in %d ... ",i);
  printclr(f_win,KEY_COLOR,A_BOLD,22,13,exestr);wrefresh(f_win);
  if(getch()!=-1) i=0;}
  nocbreak();cbreak();
}
switch (data[broj].stat) {
  case 0 :
	  test_logs("mount",f_win);break;
  case 1 :
	  test_logs("umount",f_win);break;
}
for (i=0;i<kraj1;i++){/* go thru list of devices */
 if ( (strcmp(data[i].dev,data[broj].dev)==0)&&(i!=broj) ){/* find identical */
  if(data[broj].stat==0) data[i].stat=0;
  else data[i].stat=2;
 }
}
kraj2=mtab_update(M_TAB,kraj1);delwin(f_win);/* destroy window for messeges */
}
